/*
 * Decompiled with CFR 0.152.
 */
package com.eleksploded.lavadynamics.generator;

import com.eleksploded.lavadynamics.LavaDynamics;
import com.eleksploded.lavadynamics.generator.VolcanoGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class MountianVolcanoGen
extends VolcanoGenerator {
    public List<String> biomes = new ArrayList<String>();

    public MountianVolcanoGen() {
        this.setRegistryName(new ResourceLocation("lavadynamics", "mountain_generator"));
        if (LavaDynamics.LavaConfig.getBool("debug")) {
            LavaDynamics.Logger.info("Done!");
        }
        List validBiomes = LavaDynamics.LavaConfig.getList("mountainBiomes");
        validBiomes.forEach(name -> {
            block5: {
                try {
                    ResourceLocation loc = new ResourceLocation(name);
                    Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(loc);
                    if (biome != null) {
                        this.biomes.add((String)name);
                    } else if (LavaDynamics.LavaConfig.getBool("debug")) {
                        LavaDynamics.Logger.info("Skipping invalid entry: " + name);
                    }
                }
                catch (ResourceLocationException e) {
                    if (!LavaDynamics.LavaConfig.getBool("debug")) break block5;
                    LavaDynamics.Logger.info("Skipping invalid entry: " + name);
                }
            }
        });
        if (LavaDynamics.LavaConfig.getBool("debug")) {
            LavaDynamics.Logger.info("Done!");
        }
        System.out.println(this.biomes);
    }

    @Override
    public void generate(World world, Random random, BlockPos position) {
        float j1;
        float i1;
        int z1;
        int y1;
        int x1;
        int radius;
        Random rand = new Random();
        while (world.func_175623_d(position) && position.func_177956_o() > 2 && (position = position.func_177977_b()).func_177956_o() < 255 && position.func_177956_o() > 16) {
        }
        int caldera = rand.nextInt(LavaDynamics.LavaConfig.getInt("calderaMax") - LavaDynamics.LavaConfig.getInt("calderaMin") + 1) + LavaDynamics.LavaConfig.getInt("calderaMin");
        BlockPos pos = position.func_177981_b(6);
        for (radius = caldera; radius != caldera + 3; ++radius) {
            x1 = pos.func_177958_n();
            y1 = pos.func_177956_o() - 1;
            z1 = pos.func_177952_p();
            i1 = 0.0f;
            while (i1 < (float)radius) {
                j1 = 0.0f;
                while ((double)j1 < Math.PI * 2 * (double)i1) {
                    this.setBlockWithOre(world, new BlockPos((int)Math.floor((double)x1 + Math.sin(j1) * (double)i1), y1 - radius, (int)Math.floor((double)z1 + Math.cos(j1) * (double)i1)), false, this.ores);
                    j1 = (float)((double)j1 + 0.5);
                }
                i1 = (float)((double)i1 + 0.5);
            }
        }
        for (radius = caldera - 1; radius != 0; --radius) {
            x1 = position.func_177958_n();
            y1 = position.func_177956_o() - 1;
            z1 = position.func_177952_p();
            i1 = 0.0f;
            while (i1 < (float)radius) {
                j1 = 0.0f;
                while ((double)j1 < Math.PI * 2 * (double)i1) {
                    if (LavaDynamics.LavaConfig.getBool("useBiome") && (double)i1 == (double)radius - 0.5) {
                        this.setBlockWithBiomeTop(world, new BlockPos((int)Math.floor((double)x1 + Math.sin(j1) * (double)i1), y1, (int)Math.floor((double)z1 + Math.cos(j1) * (double)i1)));
                    } else {
                        this.setBlockWithOre(world, new BlockPos((int)Math.floor((double)x1 + Math.sin(j1) * (double)i1), y1, (int)Math.floor((double)z1 + Math.cos(j1) * (double)i1)), LavaDynamics.LavaConfig.getBool("useBiome") && i1 >= (float)radius - ((float)LavaDynamics.LavaConfig.getInt("fillerSize").intValue() + 0.5f), this.ores);
                    }
                    j1 = (float)((double)j1 + 0.5);
                }
                i1 = (float)((double)i1 + 0.5);
            }
            position = position.func_177977_b();
        }
    }

    @Override
    public List<String> getValidBiomes() {
        return this.biomes;
    }
}

