/*
 * Decompiled with CFR 0.152.
 */
package com.eleksploded.lavadynamics.generator;

import com.eleksploded.lavadynamics.LavaDynamics;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class VolcanoGenerator
extends ForgeRegistryEntry<VolcanoGenerator> {
    List<BlockState> ores = new ArrayList<BlockState>();

    public abstract void generate(World var1, Random var2, BlockPos var3);

    public abstract List<String> getValidBiomes();

    void setBlockWithOre(World worldIn, BlockPos blockpos, boolean useFiller, List<BlockState> ores) {
        int chance;
        Random rand = new Random();
        int ore = rand.nextInt(1000);
        BlockState block = ore <= (chance = 1000 - LavaDynamics.LavaConfig.getInt("oreChance")) ? (useFiller ? worldIn.func_226691_t_(blockpos).func_242440_e().func_242502_e().func_204109_b() : Blocks.field_150348_b.func_176223_P()) : ores.get(rand.nextInt(ores.size()));
        worldIn.func_175656_a(blockpos, block);
    }

    void setBlockWithBiomeTop(World world, BlockPos blockpos) {
        Biome biome = world.func_226691_t_(blockpos);
        BlockState s = biome.func_242440_e().func_242502_e().func_204109_b();
        world.func_175656_a(blockpos, s);
    }

    public final void loadOres() {
        boolean debug = LavaDynamics.LavaConfig.getBool("debug");
        if (debug) {
            LavaDynamics.Logger.info("Reading Config");
        }
        List names = LavaDynamics.LavaConfig.getList("ores");
        if (debug) {
            LavaDynamics.Logger.info("Collecting ores & chances");
        }
        for (String name : names) {
            String[] split = name.split("\\|");
            if (split.length != 2) {
                LavaDynamics.Logger.error("Skipping invalid Config at " + name);
                continue;
            }
            BlockState block = Blocks.field_150348_b.func_176223_P();
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(split[0]));
            if (b != null) {
                block = b.func_176223_P();
            }
            int chance = Integer.valueOf(split[1]);
            for (int i = 0; i != chance; ++i) {
                this.ores.add(block);
            }
        }
        if (debug) {
            LavaDynamics.Logger.info("Done!");
            StringBuilder b = new StringBuilder("Ore Contents are: ");
            for (BlockState block : this.ores) {
                b.append(block.func_177230_c().getRegistryName());
            }
            LavaDynamics.Logger.info(b.toString());
        }
    }
}

