/*
 * Decompiled with CFR 0.152.
 */
package com.eleksploded.lavadynamics.hardernether;

import com.eleksploded.lavadynamics.LavaDynamics;
import com.eleksploded.lavadynamics.hardernether.cap.HarderNetherCap;
import com.eleksploded.lavadynamics.hardernether.cap.IHarderNether;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HarderNether {
    public static Map<String, HarderNether> instances = new HashMap<String, HarderNether>();
    World world;
    int max;

    public static void onLoad(World world) {
        List dims = LavaDynamics.LavaConfig.getList("harderNetherDims");
        System.out.println(world.func_234923_W_().func_240901_a_().toString() + dims);
        if (dims.contains(world.func_234923_W_().func_240901_a_().toString())) {
            instances.put(world.func_234923_W_().func_240901_a_().toString(), new HarderNether(world));
        }
    }

    public static void onUnload(World world) {
        String dim = world.func_234923_W_().func_240901_a_().toString();
        if (instances.containsKey(dim)) {
            MinecraftForge.EVENT_BUS.unregister((Object)instances.get(dim));
            instances.remove(dim);
        }
    }

    public HarderNether(World world) {
        this.world = world;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.max = LavaDynamics.LavaConfig.getInt("timeForFire");
    }

    public void processPlayer(PlayerEntity player) {
        IHarderNether hn = (IHarderNether)player.getCapability(HarderNetherCap.hardNetherCap).orElseGet(() -> null);
        if (hn == null) {
            System.out.println("Cap error on " + player.func_200200_C_().getString());
            return;
        }
        System.out.println(hn.getTimer());
        if (hn.getTimer() <= 0) {
            if (this.canBeFired(player)) {
                player.func_70015_d(1);
            } else if (hn.getTimer() < this.max) {
                hn.setTimer(hn.getTimer() + 2);
            }
        } else {
            hn.setTimer(hn.getTimer() - 1);
        }
    }

    private boolean canBeFired(PlayerEntity player) {
        if (player.func_70660_b(Effects.field_76426_n) != null) {
            return false;
        }
        int fireProt = 0;
        for (ItemStack s : player.func_184193_aE()) {
            if (s == null || !s.func_77948_v()) continue;
            for (int i = 0; i < s.func_77986_q().size(); ++i) {
                CompoundNBT n = s.func_77986_q().func_150305_b(i);
                Enchantment ench = Registry.field_212628_q.func_241873_b(ResourceLocation.func_208304_a((String)n.func_74779_i("id"))).orElseGet(() -> null);
                if (ench == null || ench != Enchantments.field_77329_d) continue;
                fireProt += n.func_74762_e("lvl");
            }
        }
        return fireProt < LavaDynamics.LavaConfig.getInt("fireProtRequire");
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent e) {
        if (!e.player.field_70170_p.field_72995_K && e.player.field_70170_p.func_234923_W_().equals(this.world.func_234923_W_())) {
            this.processPlayer(e.player);
        }
    }

    @SubscribeEvent
    public void changeDims(PlayerEvent.PlayerChangedDimensionEvent e) {
        if (!e.getPlayer().field_70170_p.field_72995_K) {
            e.getPlayer().getCapability(HarderNetherCap.hardNetherCap).ifPresent(cap -> cap.setTimer(this.max));
        }
    }
}

