/*
 * Decompiled with CFR 0.152.
 */
package com.eleksploded.lavadynamics.postgen;

import com.eleksploded.lavadynamics.LavaDynamics;
import com.eleksploded.lavadynamics.cap.CheckedCap;
import com.eleksploded.lavadynamics.postgen.PostGenEffect;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public class PostGenEffectThread
implements Runnable {
    ServerWorld world;
    int oldTick = 0;
    int newTick = 1;
    boolean running = true;
    boolean success = false;

    public PostGenEffectThread(ServerWorld world) {
        this.world = world;
    }

    public void unload() {
        this.running = false;
    }

    @Override
    public void run() {
        boolean debug = LavaDynamics.LavaConfig.getBool("postgendebug");
        this.oldTick = new Long(this.world.func_82737_E()).intValue();
        this.newTick = this.oldTick + LavaDynamics.LavaConfig.getInt("PostGenEffectCooldown");
        while (this.running) {
            int tickTime = new Long(this.world.func_82737_E()).intValue();
            if (tickTime < this.oldTick) {
                this.oldTick = tickTime;
                this.newTick = this.oldTick + LavaDynamics.LavaConfig.getInt("PostGenEffectCooldown");
            }
            if (tickTime < this.oldTick + 1) continue;
            ++this.oldTick;
            if (this.newTick >= this.oldTick) continue;
            this.success = false;
            Iterable chunks = this.world.func_72863_F().field_217237_a.func_223491_f();
            int count = this.world.func_72863_F().field_217237_a.func_219194_d();
            if (count <= 0) {
                return;
            }
            StreamSupport.stream(chunks.spliterator(), false).skip(this.world.func_201674_k().nextInt(count)).findFirst().ifPresent(chunkHolder -> {
                Chunk chunk = chunkHolder.func_219298_c();
                if (chunk == null) {
                    return;
                }
                if (debug) {
                    LavaDynamics.Logger.info("Random Chunk " + chunk.func_76632_l().toString() + " for postgen Effect");
                }
                chunk.getCapability(CheckedCap.checkedCap).ifPresent(checked -> {
                    if (checked.isVolcano()) {
                        if (checked.getCooldown() > 0) {
                            checked.setCooldown(checked.getCooldown() - 1);
                        } else {
                            IForgeRegistry reg = GameRegistry.findRegistry(PostGenEffect.class);
                            ResourceLocation key = (ResourceLocation)reg.getKeys().stream().skip(this.world.field_73012_v.nextInt((int)reg.getKeys().stream().count())).findFirst().get();
                            List blacklistedEffects = LavaDynamics.LavaConfig.getList("blacklistEffects");
                            if (!blacklistedEffects.contains(key.toString())) {
                                if (debug) {
                                    LavaDynamics.Logger.info("Running effect" + key.toString() + " on chunk " + chunk.func_76632_l().toString());
                                }
                                ((PostGenEffect)reg.getValue(key)).execute(chunk, checked.getTop());
                                this.success = true;
                            }
                        }
                    }
                });
            });
            if (!this.success) continue;
            this.oldTick = tickTime;
            this.newTick = this.oldTick + LavaDynamics.LavaConfig.getInt("PostGenEffectCooldown");
        }
    }

    @Mod.EventBusSubscriber(modid="lavadynamics")
    public static class PostGenEffectThreadHandler {
        static Map<ResourceLocation, PostGenEffectThread> pge = new HashMap<ResourceLocation, PostGenEffectThread>();

        @SubscribeEvent
        public static void worldLoad(WorldEvent.Load e) {
            ServerWorld world;
            String dimKey;
            List validDims;
            if (!e.getWorld().func_201670_d() && LavaDynamics.LavaConfig.getBool("enablePostGenEffects") && (validDims = LavaDynamics.LavaConfig.getList("validDims")).contains(dimKey = (world = (ServerWorld)e.getWorld()).func_234923_W_().func_240901_a_().toString())) {
                LavaDynamics.Logger.info("Starting PostGenEffectThread for " + dimKey);
                PostGenEffectThread i = new PostGenEffectThread(world);
                Thread t = new Thread(i);
                pge.put(world.func_234923_W_().func_240901_a_(), i);
                t.start();
            }
        }

        @SubscribeEvent
        public static void worldUnload(WorldEvent.Unload e) {
            ServerWorld world;
            ResourceLocation key;
            if (!e.getWorld().func_201670_d() && LavaDynamics.LavaConfig.getBool("enablePostGenEffects") && pge.containsKey(key = (world = (ServerWorld)e.getWorld()).func_234923_W_().func_240901_a_())) {
                LavaDynamics.Logger.info("Stopping PostGenEffectThread for " + key.toString());
                pge.get(key).unload();
            }
        }
    }
}

