/*
 * Decompiled with CFR 0.152.
 */
package com.eleksploded.lavadynamics.utils;

import com.eleksploded.lavadynamics.LavaDynamics;
import com.eleksploded.lavadynamics.cap.CheckedCap;
import com.eleksploded.lavadynamics.cap.IChecked;
import com.eleksploded.lavadynamics.utils.VolcanoCache;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;

public class Utils {
    public static boolean isVolcanoInRange(ServerWorld world, Chunk c) {
        boolean debug = LavaDynamics.LavaConfig.getBool("debug");
        int r = LavaDynamics.LavaConfig.getInt("volcanoDistance");
        if (debug) {
            LavaDynamics.Logger.debug("Range is " + r);
        }
        for (int x = -r; x < r; ++x) {
            for (int z = -r; z < r; ++z) {
                ChunkPos pos = new ChunkPos(c.func_76632_l().field_77276_a + x, c.func_76632_l().field_77275_b + z);
                VolcanoCache.CacheResult result = VolcanoCache.getCacheResult(pos);
                if (result != VolcanoCache.CacheResult.NON_CACHED) {
                    if (debug) {
                        LavaDynamics.Logger.debug("Found Chunk in cache, checking");
                    }
                    if (result != VolcanoCache.CacheResult.VOLCANO) continue;
                    return true;
                }
                BlockPos from = new BlockPos(pos.func_180334_c(), 0, pos.func_180333_d());
                BlockPos to = new BlockPos(pos.func_180332_e(), 255, pos.func_180330_f());
                if (debug) {
                    LavaDynamics.Logger.debug("Range check on " + (c.func_76632_l().field_77276_a + x) + "|" + (c.func_76632_l().field_77275_b + z));
                }
                if (!world.func_175707_a(from, to)) {
                    if (!debug) continue;
                    LavaDynamics.Logger.debug("Chunk isnt loaded. Skipping");
                    continue;
                }
                Chunk t = world.func_212866_a_(c.func_76632_l().field_77276_a + x, c.func_76632_l().field_77275_b + z);
                IChecked tc = (IChecked)t.getCapability(CheckedCap.checkedCap).orElseThrow(() -> new RuntimeException("Error getting Checked Capability, Please report on the github page"));
                if (tc.isVolcano()) {
                    if (debug) {
                        LavaDynamics.Logger.debug("Found Volcano");
                    }
                    return true;
                }
                if (!debug) continue;
                LavaDynamics.Logger.debug("No Volcano");
            }
        }
        return false;
    }

    public static List<Chunk> getLoadedChunks(ServerWorld world) {
        ArrayList<Chunk> list = new ArrayList<Chunk>();
        Iterable chunks = world.func_72863_F().field_217237_a.func_223491_f();
        chunks.forEach(c -> {
            Chunk ch = c.func_219298_c();
            if (ch != null) {
                list.add(ch);
            }
        });
        return list;
    }
}

