/*
 * Decompiled with CFR 0.152.
 */
package com.eleksploded.eleklib;

import com.eleksploded.eleklib.ElekLib;
import java.io.File;
import java.util.Arrays;

public class LogCleanup {
    static void run() {
        if (ElekLib.ElekLibConfig.getBool("cleanup-logs")) {
            LogCleanup.cleanLog();
        }
        if (ElekLib.ElekLibConfig.getBool("cleanup-crash")) {
            LogCleanup.cleanCrash();
        }
    }

    private static void cleanLog() {
        File dir = ElekLib.proxy.getGameFolder("logs");
        File[] files = LogCleanup.sortFiles(dir);
        if (files == null) {
            return;
        }
        int n = ElekLib.ElekLibConfig.getInt("max-log");
        for (int i = 0; i < files.length - n; ++i) {
            files[i].delete();
        }
    }

    private static void cleanCrash() {
        File dir = ElekLib.proxy.getGameFolder("crash-reports");
        File[] files = LogCleanup.sortFiles(dir);
        if (files == null) {
            return;
        }
        int n = ElekLib.ElekLibConfig.getInt("max-crash");
        for (int i = 0; i < files.length - n; ++i) {
            files[i].delete();
        }
    }

    private static File[] sortFiles(File dir) {
        int i;
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            return null;
        }
        Object[] pairs = new Pair[files.length];
        for (i = 0; i < files.length; ++i) {
            pairs[i] = new Pair(files[i]);
        }
        Arrays.sort(pairs);
        for (i = 0; i < files.length; ++i) {
            files[i] = ((Pair)pairs[i]).f;
        }
        pairs = null;
        return files;
    }

    private static class Pair
    implements Comparable {
        public long t;
        public File f;

        public Pair(File file) {
            this.f = file;
            this.t = file.lastModified();
        }

        public int compareTo(Object o) {
            long u = ((Pair)o).t;
            return this.t < u ? -1 : (this.t == u ? 0 : 1);
        }
    }
}

