/*
 * Decompiled with CFR 0.152.
 */
package com.eleksploded.eleklib.config;

import com.eleksploded.eleklib.config.Config;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ModConfig;

public class ConfigBuilder {
    ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    Config config = new Config();

    public static ConfigBuilder builder() {
        return new ConfigBuilder();
    }

    public ConfigBuilder enterCategory(String name, String desc) {
        this.builder.comment(desc).push(name);
        return this;
    }

    public ConfigBuilder category(String name, String desc, Consumer<ConfigBuilder> c) {
        this.enterCategory(name, desc);
        c.accept(this);
        this.exitCategory();
        return this;
    }

    public ConfigBuilder exitCategory() {
        this.builder.pop();
        return this;
    }

    public ConfigBuilder addBool(String key, boolean defaultValue, String desc) {
        ForgeConfigSpec.BooleanValue spec = this.builder.comment(desc).define(key, defaultValue);
        this.config.bools.put(key, spec);
        return this;
    }

    public ConfigBuilder addLong(String key, Long defaultValue, String desc, Long min, Long max) {
        ForgeConfigSpec.LongValue spec = this.builder.comment(desc).defineInRange(key, defaultValue.longValue(), min.longValue(), max.longValue());
        this.config.longs.put(key, spec);
        return this;
    }

    public ConfigBuilder addInt(String key, Integer defaultValue, String desc, Integer min, Integer max) {
        ForgeConfigSpec.IntValue spec = this.builder.comment(desc).defineInRange(key, defaultValue.intValue(), min.intValue(), max.intValue());
        this.config.ints.put(key, spec);
        return this;
    }

    public ConfigBuilder addDouble(String key, Double defaultValue, String desc, Double min, Double max) {
        ForgeConfigSpec.DoubleValue spec = this.builder.comment(desc).defineInRange(key, defaultValue.doubleValue(), min.doubleValue(), max.doubleValue());
        this.config.doubles.put(key, spec);
        return this;
    }

    public ConfigBuilder addString(String key, String defaultValue, String desc) {
        ForgeConfigSpec.ConfigValue spec = this.builder.comment(desc).define(key, (Object)defaultValue);
        this.config.strings.put(key, (ForgeConfigSpec.ConfigValue<String>)spec);
        return this;
    }

    public <T> ConfigBuilder addList(String key, List<? extends T> defaultValue, String desc, Predicate<Object> validator) {
        ForgeConfigSpec.ConfigValue spec = this.builder.comment(desc).defineList(key, defaultValue, validator);
        this.config.lists.put(key, spec);
        return this;
    }

    public Config build(String modId, ModConfig.Type type) {
        ModContainer c = (ModContainer)ModList.get().getModContainerById(modId).orElseThrow(() -> new RuntimeException("Attempted to build config for an invalid modId"));
        c.addConfig(new ModConfig(type, this.builder.build(), c));
        return this.config;
    }

    public Config build(String modId, ModConfig.Type type, String filename) {
        if (!filename.endsWith(".toml")) {
            filename = filename.concat(".toml");
        }
        ModContainer c = (ModContainer)ModList.get().getModContainerById(modId).orElseThrow(() -> new RuntimeException("Attempted to build config for an invalid modId"));
        c.addConfig(new ModConfig(type, this.builder.build(), c, filename));
        return this.config;
    }
}

