/*
 * Decompiled with CFR 0.152.
 */
package com.eleksploded.eleklib.updatecheck;

import com.eleksploded.eleklib.ElekLib;
import com.eleksploded.eleklib.updatecheck.UpdateCheckThread;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class UpdateChecker {
    private static UpdateChecker instance = null;

    private UpdateChecker() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        instance = this;
    }

    public static void init() {
        if (instance == null) {
            new UpdateChecker();
        }
    }

    public static UpdateChecker instance() {
        return instance;
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent e) {
        if (FMLEnvironment.dist == Dist.CLIENT && e.getEntity() instanceof PlayerEntity) {
            this.runUpdateChecks();
        }
    }

    @SubscribeEvent
    public void onWorldLoaded(WorldEvent.Load e) {
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            this.runUpdateChecks();
        }
    }

    public void runUpdateChecks() {
        List<?> ignored = ElekLib.ElekLibConfig.getList("ignoreUpdates");
        ModList.get().forEachModContainer((modid, container) -> {
            if (!ignored.contains(container.getModInfo().getModId())) {
                ElekLib.debug("Running update checker for " + modid);
                Thread thread = new Thread(new UpdateCheckThread((ModContainer)container));
                thread.start();
            }
        });
    }

    public static void sendMessage(String message, String ... args) {
        System.out.println(message + Arrays.toString(args));
        for (int i = 0; i < args.length; ++i) {
            message = message.replace("$" + String.valueOf(i + 1), args[i]);
        }
        ElekLib.proxy.sendMessage(message);
    }
}

