/*
 * Decompiled with CFR 0.152.
 */
package me.cameronwhyte.mods.lavasmelting;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lavasmelting")
public class LavaSmelting {
    private static final Logger LOGGER = LogManager.getLogger();
    private OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    private Random random = new Random();

    public LavaSmelting() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Lava Smelting is setup!");
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        LOGGER.info("Lava Smelting client is setup!");
    }

    @SubscribeEvent
    public void burnableItem(ItemTossEvent event) {
        ItemEntity tossed = event.getEntityItem();
        Optional canBeSmelted = tossed.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new Inventory(new ItemStack[]{tossed.func_92059_d()}), tossed.field_70170_p);
        if (!canBeSmelted.isPresent()) {
            return;
        }
        if (this.osBean.getProcessCpuLoad() > 0.9) {
            this.surrenderItem();
        }
        World world = tossed.field_70170_p;
        ItemEntity smelted = new ItemEntity(world, tossed.func_226277_ct_(), tossed.func_226278_cu_(), tossed.func_226281_cx_(), ((FurnaceRecipe)canBeSmelted.get()).func_77571_b());
        smelted.func_92059_d().func_190920_e(tossed.func_92059_d().func_190916_E());
        AtomicBoolean hasBeenBurned = new AtomicBoolean(false);
        Thread cancelBurning = new Thread(() -> {
            while (true) {
                if (!hasBeenBurned.get() && (tossed.func_180799_ab() || tossed.func_70027_ad())) {
                    smelted.func_70107_b(tossed.func_226277_ct_(), tossed.func_226278_cu_(), tossed.func_226281_cx_());
                    world.func_217376_c((Entity)smelted);
                    hasBeenBurned.set(true);
                }
                if (!hasBeenBurned.get()) continue;
                if (smelted.func_180799_ab() || smelted.func_70027_ad()) {
                    smelted.func_70066_B();
                    smelted.func_184224_h(true);
                    smelted.func_213293_j(this.random.nextGaussian() / 8.0, 0.15, this.random.nextGaussian() / 8.0);
                }
                smelted.func_184224_h(false);
            }
        });
        cancelBurning.setName(smelted.func_110124_au().toString() + "_lavasmelting");
        cancelBurning.start();
    }

    @SubscribeEvent
    public void pickupBurnedItem(PlayerEvent.ItemPickupEvent event) {
        Map<Thread, StackTraceElement[]> allThreads = Thread.getAllStackTraces();
        allThreads.forEach((x, e) -> {
            if (x.getName().equals(event.getOriginalEntity().func_110124_au().toString() + "_lavasmelting")) {
                x.stop();
            }
        });
    }

    @SubscribeEvent
    public void burnedItemDespawn(ItemExpireEvent event) {
        Map<Thread, StackTraceElement[]> allThreads = Thread.getAllStackTraces();
        allThreads.forEach((x, e) -> {
            if (x.getName().equals(event.getEntityItem().func_110124_au().toString() + "_lavasmelting")) {
                x.stop();
            }
        });
    }

    private void surrenderItem() {
        Map<Thread, StackTraceElement[]> allThreads = Thread.getAllStackTraces();
        allThreads.forEach((x, e) -> {
            if (x.getName().contains("_lavasmelting")) {
                x.stop();
            }
        });
    }
}

