/*
 * Decompiled with CFR 0.152.
 */
package com.firecontroller1847.levelhearts;

import com.firecontroller1847.levelhearts.Config;
import com.firecontroller1847.levelhearts.LevelHearts;
import com.firecontroller1847.levelhearts.capabilities.IMoreHealth;
import com.firecontroller1847.levelhearts.capabilities.MoreHealth;
import com.firecontroller1847.levelhearts.capabilities.MoreHealthProvider;
import com.firecontroller1847.levelhearts.commands.LevelHeartsCommand;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.fmlserverevents.FMLServerStartingEvent;

@Mod.EventBusSubscriber(modid="levelhearts", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Events {
    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer().m_20193_().f_46443_) {
            return;
        }
        LevelHearts.debug("PlayerLoggedIn{Event}");
        Player player = event.getPlayer();
        IMoreHealth cap = MoreHealth.getFromPlayer(player);
        LevelHearts.applyHealthModifier(player, cap.getTrueModifier());
        if (cap.getVersion() == 1) {
            LevelHearts.debug("PlayerLoggedIn{Event}: New player! Initiating data.");
            LevelHearts.debug("PlayerLoggedIn{Event}: Searching for v1 data.");
            CompoundTag data = player.getPersistentData();
            if (data.m_128441_("levelHearts")) {
                LevelHearts.debug("PlayerLoggedIn{Event}: Data found. Migrating!");
                CompoundTag tag = data.m_128469_("levelHearts");
                cap.setModifier((float)tag.m_128459_("modifier"));
                cap.setRampPosition(tag.m_128445_("levelRampPosition"));
                cap.setHeartContainers(tag.m_128445_("heartContainers"));
                LevelHearts.applyHealthModifier(player, cap.getTrueModifier());
                data.m_128473_("levelHearts");
            } else {
                LevelHearts.debug("PlayerLoggedIn{Event}: No v1 data found.");
            }
            player.m_21153_(player.m_21233_());
            cap.setVersion((byte)2);
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            LevelHearts.debug("AttachCapabilities{Event}");
            event.addCapability(new ResourceLocation("levelhearts", "morehealth"), (ICapabilityProvider)new MoreHealthProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        LevelHearts.debug("PlayerClone{Event}");
        Player playerOld = event.getOriginal();
        playerOld.reviveCaps();
        Player playerNew = event.getPlayer();
        IMoreHealth capOld = MoreHealth.getFromPlayer(playerOld);
        IMoreHealth capNew = MoreHealth.getFromPlayer(playerNew);
        capNew.copy(capOld);
        playerOld.invalidateCaps();
        if (!event.isWasDeath()) {
            LevelHearts.debug("PlayerClone{Event}: Cloning from dimension change, re-applying health modifier.");
            LevelHearts.applyHealthModifier(playerNew, capNew.getTrueModifier());
            playerNew.m_21153_(playerOld.m_21223_());
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getPlayer().m_20193_().f_46443_) {
            return;
        }
        LevelHearts.debug("PlayerRespawn{Event}");
        Player player = event.getPlayer();
        IMoreHealth cap = MoreHealth.getFromPlayer(player);
        if (event.isEndConquered()) {
            LevelHearts.debug("PlayerRespawn{Event}: Coming from end, syncing!");
            MoreHealth.updateClient((ServerPlayer)player, cap);
            return;
        }
        if (((Boolean)Config.enableHardcore.get()).booleanValue()) {
            LevelHearts.debug("PlayerRespawn{Event}: Hardcore mode enabled, removing health.");
            player.m_6352_((Component)new TranslatableComponent("text.levelhearts.hardcore"), Util.f_137441_);
            cap.setModifier(MoreHealth.getDefaultModifier());
            cap.setRampPosition((short)0);
            cap.setHeartContainers((byte)0);
            MoreHealth.updateClient((ServerPlayer)player, cap);
        } else if ((Integer)Config.punishAmount.get() > 0) {
            LevelHearts.debug("PlayerRespawn{Event}: Punishment enabled, removing health.");
            int amount = (Integer)Config.punishAmount.get() * 2;
            float oldModifier = cap.getModifier();
            float newModifier = oldModifier - (float)amount;
            if (newModifier < MoreHealth.getDefaultModifier()) {
                float healthLeft = newModifier - MoreHealth.getDefaultModifier();
                byte containers = cap.getHeartContainers();
                byte containersLeft = (byte)Math.max((float)containers + healthLeft / 2.0f, 0.0f);
                cap.setModifier(MoreHealth.getDefaultModifier());
                cap.setRampPosition((short)0);
                cap.setHeartContainers(containersLeft);
                float xpHeartsLost = oldModifier / 2.0f;
                byte containersLost = (byte)(containers - containersLeft);
                int heartsLost = (int)xpHeartsLost + containersLost;
                if (heartsLost > 0) {
                    player.m_6352_((Component)new TranslatableComponent("text.levelhearts.punish", new Object[]{heartsLost}), Util.f_137441_);
                }
            } else {
                cap.setModifier(newModifier);
                cap.setRampPosition((short)(newModifier / 2.0f));
                player.m_6352_((Component)new TranslatableComponent("text.levelhearts.punish", new Object[]{amount / 2}), Util.f_137441_);
            }
            MoreHealth.updateClient((ServerPlayer)player, cap);
        }
        if (((Boolean)Config.loseXpOnDeath.get()).booleanValue()) {
            player.m_6749_(-player.f_36078_ - 1);
        }
        LevelHearts.recalcPlayerHealth(player, player.f_36078_);
        LevelHearts.applyHealthModifier(player, cap.getTrueModifier());
        player.m_21153_(player.m_21233_());
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        if (event.getEntity().m_20193_().f_46443_) {
            return;
        }
        LevelHearts.debug("LivingDamage{Event}");
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (((Boolean)Config.enableOhko.get()).booleanValue()) {
            player.m_21153_(0.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntity().m_20193_().f_46443_) {
            return;
        }
        LevelHearts.debug("LivingDeath{Event}");
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (((Boolean)Config.loseInvOnDeath.get()).booleanValue()) {
            try {
                ObfuscationReflectionHelper.findMethod(Player.class, (String)"dropEquipment", (Class[])new Class[0]).invoke((Object)player, new Object[0]);
                ObfuscationReflectionHelper.findMethod(Player.class, (String)"destroyVanishingCursedItems", (Class[])new Class[0]).invoke((Object)player, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            player.m_150109_().m_36071_();
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getPlayer().m_20193_().f_46443_) {
            return;
        }
        LevelHearts.debug("PlayerChangedDimension{Event}");
        Player player = event.getPlayer();
        IMoreHealth cap = MoreHealth.getFromPlayer(player);
        LevelHearts.applyHealthModifier(player, cap.getTrueModifier());
        cap.synchronise(player);
    }

    @SubscribeEvent
    public static void onPlayerLevelUp(PlayerXpEvent.LevelChange event) {
        if (event.getPlayer().m_20193_().f_46443_) {
            return;
        }
        LevelHearts.debug("PlayerLevelChange{Event}");
        Player player = event.getPlayer();
        LevelHearts.recalcPlayerHealth(player, player.f_36078_ + event.getLevels());
    }

    @SubscribeEvent
    public static void onPlayerPickupXp(PlayerXpEvent.PickupXp event) {
        LevelHearts.debug("PlayerPickupXp{Event}");
        event.getOrb().f_20770_ = (int)((double)event.getOrb().f_20770_ * (Double)Config.xpMultiplier.get());
    }

    @SubscribeEvent
    public static void onExperienceDrop(LivingExperienceDropEvent event) {
        if (((Boolean)Config.loseXpOnDeath.get()).booleanValue() && event.getEntity() instanceof Player) {
            LevelHearts.debug("ExperienceDrop{Event}");
            Player player = (Player)event.getEntity();
            int i = player.f_36078_ * 7;
            event.setDroppedExperience(Math.min(i, 100));
        }
    }

    @SubscribeEvent
    public static void onServerStarting(FMLServerStartingEvent event) {
        CommandDispatcher dispatcher = event.getServer().m_129892_().m_82094_();
        LevelHeartsCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }
}

