/*
 * Decompiled with CFR 0.152.
 */
package com.firecontroller1847.levelhearts;

import com.firecontroller1847.levelhearts.Config;
import com.firecontroller1847.levelhearts.PacketManager;
import com.firecontroller1847.levelhearts.capabilities.IMoreHealth;
import com.firecontroller1847.levelhearts.capabilities.MoreHealth;
import com.firecontroller1847.levelhearts.gui.IngameGui;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="levelhearts")
@Mod.EventBusSubscriber(modid="levelhearts", bus=Mod.EventBusSubscriber.Bus.MOD)
public class LevelHearts {
    public static final String MOD_ID = "levelhearts";
    public static final String MOD_NAME = "LevelHearts";
    public static final String MOD_VERSION = "2.2.0";
    private static final UUID MODIFIER_ID = UUID.fromString("81f27f52-c8bb-403a-a1a4-b356d2f7a0f0");
    private static final Logger logger = LogManager.getLogger((String)"levelhearts");

    public LevelHearts() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC, "levelhearts.toml");
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(IMoreHealth.class);
        PacketManager.register();
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new IngameGui());
    }

    public static void debug(String message) {
        if (((Boolean)Config.enableDebug.get()).booleanValue()) {
            logger.info(message);
        }
    }

    public static void debug(Object object) {
        LevelHearts.debug(object.toString());
    }

    public static void error(Exception exception) {
        logger.throwing((Throwable)exception);
    }

    public static void applyHealthModifier(Player player, double amount) {
        LevelHearts.debug("LevelHearts#applyHealthModifier");
        AttributeModifier modifier = new AttributeModifier(MODIFIER_ID, "levelHearts.healthModifier", amount, AttributeModifier.Operation.ADDITION);
        AttributeInstance attribute = player.m_21051_(Attributes.f_22276_);
        attribute.m_22130_(modifier);
        attribute.m_22125_(modifier);
    }

    public static void recalcPlayerHealth(Player player, int level) {
        LevelHearts.debug("LevelHearts#calcPlayerHealth");
        IMoreHealth cap = MoreHealth.getFromPlayer(player);
        ArrayList ramp = (ArrayList)Config.levelRamp.get();
        int max = (Integer)Config.maxHealth.get() > 0 ? (Integer)Config.maxHealth.get() : 1024;
        boolean changed = false;
        if (cap.getRampPosition() < 0) {
            cap.setRampPosition((short)0);
        }
        while (cap.getRampPosition() < ramp.size() && level >= (Integer)ramp.get(cap.getRampPosition()) && player.m_21233_() < (float)max) {
            LevelHearts.debug("LevelHearts#calcPlayerHealth: Adding a heart to the player.");
            changed = true;
            cap.addRampPosition();
            cap.setModifier(cap.getModifier() + 2.0f);
            player.m_6352_((Component)new TranslatableComponent("text.levelhearts.heartadded"), Util.f_137441_);
            LevelHearts.applyHealthModifier(player, cap.getTrueModifier());
        }
        if (changed) {
            MoreHealth.updateClient((ServerPlayer)player, cap);
            player.m_21153_(player.m_21233_());
        }
    }
}

