/*
 * Decompiled with CFR 0.152.
 */
package com.firecontroller1847.levelhearts.capabilities;

import com.firecontroller1847.levelhearts.Config;
import com.firecontroller1847.levelhearts.PacketManager;
import com.firecontroller1847.levelhearts.capabilities.IMoreHealth;
import com.firecontroller1847.levelhearts.capabilities.MoreHealthProvider;
import com.firecontroller1847.levelhearts.packets.SyncHealthPacket;
import java.util.Collections;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class MoreHealth
implements IMoreHealth {
    private byte version = 1;
    private float modifier = MoreHealth.getDefaultModifier();
    private short rampPosition = 0;
    private byte containers;

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public float getModifier() {
        return this.modifier;
    }

    @Override
    public float getTrueModifier() {
        return this.modifier + (float)(this.containers * 2);
    }

    @Override
    public short getRampPosition() {
        return this.rampPosition;
    }

    @Override
    public byte getHeartContainers() {
        return this.containers;
    }

    @Override
    public void setVersion(byte version) {
        this.version = version;
    }

    @Override
    public void setModifier(float modifier) {
        this.modifier = modifier;
    }

    @Override
    public void setRampPosition(short position) {
        this.rampPosition = position;
    }

    @Override
    public void addRampPosition() {
        this.rampPosition = (short)(this.rampPosition + 1);
    }

    @Override
    public void setHeartContainers(byte amount) {
        this.containers = amount;
    }

    @Override
    public void addHeartContainer() {
        this.containers = (byte)(this.containers + 1);
    }

    @Override
    public void copy(IMoreHealth other) {
        this.setVersion(other.getVersion());
        this.setModifier(other.getModifier());
        this.setRampPosition(other.getRampPosition());
        this.setHeartContainers(other.getHeartContainers());
    }

    @Override
    public void synchronise(Player player) {
        if (!player.m_20193_().f_46443_) {
            AttributeInstance attribute = player.m_21051_(Attributes.f_22276_);
            ClientboundUpdateAttributesPacket packet = new ClientboundUpdateAttributesPacket(player.m_142049_(), Collections.singleton(attribute));
            ((ServerLevel)player.m_20193_()).m_7726_().m_8394_((Entity)player, (Packet)packet);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128344_("version", this.version);
        tag.m_128350_("modifier", this.modifier);
        tag.m_128376_("position", this.rampPosition);
        tag.m_128344_("containers", this.containers);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.setVersion(tag.m_128445_("version"));
        this.setModifier(tag.m_128457_("modifier"));
        this.setRampPosition(tag.m_128448_("position"));
        this.setHeartContainers(tag.m_128445_("containers"));
    }

    public static float getDefaultModifier() {
        return (float)((Integer)Config.defHealth.get()).intValue() - (float)Attributes.f_22276_.m_22082_();
    }

    public static IMoreHealth getFromPlayer(Player player) {
        return (IMoreHealth)player.getCapability(MoreHealthProvider.CAPABILITY, null).orElseThrow(() -> new IllegalArgumentException("LazyOptional must not be empty!"));
    }

    public static void updateClient(ServerPlayer player, IMoreHealth cap) {
        PacketManager.sendTo(player, new SyncHealthPacket(player.m_142049_(), (CompoundTag)cap.serializeNBT()));
    }

    public String toString() {
        return String.format("MoreHealth{version=%s,modifier=%s,rampPosition=%s, containers=%s}", this.version, Float.valueOf(this.modifier), this.rampPosition, this.containers);
    }
}

