/*
 * Decompiled with CFR 0.152.
 */
package com.firecontroller1847.levelhearts.commands;

import com.firecontroller1847.levelhearts.LevelHearts;
import com.firecontroller1847.levelhearts.capabilities.IMoreHealth;
import com.firecontroller1847.levelhearts.capabilities.MoreHealth;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class LevelHeartsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode command = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"levelhearts").requires(context -> context.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"hearts").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91466_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> LevelHeartsCommand.addHealth((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), true))).then(Commands.m_82129_((String)"heal", (ArgumentType)BoolArgumentType.bool()).executes(context -> LevelHeartsCommand.addHealth((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), BoolArgumentType.getBool((CommandContext)context, (String)"heal")))))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91466_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> LevelHeartsCommand.setHealth((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), true))).then(Commands.m_82129_((String)"heal", (ArgumentType)BoolArgumentType.bool()).executes(context -> LevelHeartsCommand.setHealth((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), BoolArgumentType.getBool((CommandContext)context, (String)"heal"))))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"containers").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91466_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)-127, (int)127)).executes(context -> LevelHeartsCommand.addContainers((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), true))).then(Commands.m_82129_((String)"heal", (ArgumentType)BoolArgumentType.bool()).executes(context -> LevelHeartsCommand.addContainers((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), BoolArgumentType.getBool((CommandContext)context, (String)"heal")))))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91466_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)127)).executes(context -> LevelHeartsCommand.setContainers((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), true))).then(Commands.m_82129_((String)"heal", (ArgumentType)BoolArgumentType.bool()).executes(context -> LevelHeartsCommand.setContainers((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), BoolArgumentType.getBool((CommandContext)context, (String)"heal")))))))));
    }

    private static int addHealth(CommandSourceStack source, ServerPlayer targetPlayer, int amount, boolean heal) {
        LevelHearts.debug("LevelHeartsCommand#addHealth: Adding " + amount * 2 + " health!");
        IMoreHealth cap = MoreHealth.getFromPlayer((Player)targetPlayer);
        float newModifier = cap.getModifier() + (float)(amount * 2);
        if (newModifier <= -((float)Attributes.f_22276_.m_22082_())) {
            newModifier = amount > 0 ? 1024.0f : -((float)Attributes.f_22276_.m_22082_()) + 2.0f;
        }
        cap.setModifier(newModifier);
        cap.setRampPosition((short)0);
        MoreHealth.updateClient(targetPlayer, cap);
        LevelHearts.applyHealthModifier((Player)targetPlayer, cap.getTrueModifier());
        if (heal) {
            targetPlayer.m_21153_(targetPlayer.m_21233_());
        } else {
            targetPlayer.m_21153_(targetPlayer.m_21223_() - 1.0f);
            targetPlayer.m_21153_(targetPlayer.m_21223_() + 1.0f);
        }
        return 1;
    }

    private static int setHealth(CommandSourceStack source, ServerPlayer targetPlayer, int amount, boolean heal) {
        LevelHearts.debug("LevelHeartsCommand#addHealth: Setting health to " + amount * 2 + "!");
        IMoreHealth cap = MoreHealth.getFromPlayer((Player)targetPlayer);
        cap.setModifier((float)(amount * 2) - (float)Attributes.f_22276_.m_22082_());
        cap.setRampPosition((short)0);
        MoreHealth.updateClient(targetPlayer, cap);
        LevelHearts.applyHealthModifier((Player)targetPlayer, cap.getTrueModifier());
        if (heal) {
            targetPlayer.m_21153_(targetPlayer.m_21233_());
        } else {
            targetPlayer.m_21153_(targetPlayer.m_21223_() - 1.0f);
            targetPlayer.m_21153_(targetPlayer.m_21223_() + 1.0f);
        }
        return 1;
    }

    private static int addContainers(CommandSourceStack source, ServerPlayer targetPlayer, int amount, boolean heal) {
        LevelHearts.debug("LevelHeartsCommand#addHealth: Adding " + amount + " heart containers!");
        IMoreHealth cap = MoreHealth.getFromPlayer((Player)targetPlayer);
        int newContainers = cap.getHeartContainers() + amount;
        if (newContainers < 0) {
            newContainers = amount > 0 ? 127 : 0;
        }
        cap.setHeartContainers((byte)newContainers);
        MoreHealth.updateClient(targetPlayer, cap);
        LevelHearts.applyHealthModifier((Player)targetPlayer, cap.getTrueModifier());
        if (heal) {
            targetPlayer.m_21153_(targetPlayer.m_21233_());
        } else {
            targetPlayer.m_21153_(targetPlayer.m_21223_() - 1.0f);
            targetPlayer.m_21153_(targetPlayer.m_21223_() + 1.0f);
        }
        return 1;
    }

    private static int setContainers(CommandSourceStack source, ServerPlayer targetPlayer, int amount, boolean heal) {
        LevelHearts.debug("LevelHeartsCommand#addHealth: Setting heart containers to " + amount + "!");
        IMoreHealth cap = MoreHealth.getFromPlayer((Player)targetPlayer);
        cap.setHeartContainers((byte)amount);
        MoreHealth.updateClient(targetPlayer, cap);
        LevelHearts.applyHealthModifier((Player)targetPlayer, cap.getTrueModifier());
        if (heal) {
            targetPlayer.m_21153_(targetPlayer.m_21233_());
        } else {
            targetPlayer.m_21153_(targetPlayer.m_21223_() - 1.0f);
            targetPlayer.m_21153_(targetPlayer.m_21223_() + 1.0f);
        }
        return 1;
    }
}

