/*
 * Decompiled with CFR 0.152.
 */
package com.firecontroller1847.levelhearts.gui;

import com.firecontroller1847.levelhearts.Config;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class IngameGui
extends GuiComponent {
    private final Random rand = new Random();
    private Minecraft minecraft = Minecraft.m_91087_();
    long healthUpdateCounter;
    int playerHealth;
    int lastPlayerHealth;
    long lastSystemTime;

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.PreLayer event) {
        if (!((Boolean)Config.customHud.get()).booleanValue()) {
            return;
        }
        if (event.getOverlay() == ForgeIngameGui.ARMOR_LEVEL_ELEMENT) {
            event.setCanceled(true);
            this.redrawArmor(event);
        } else if (event.getOverlay() == ForgeIngameGui.AIR_LEVEL_ELEMENT && !((Boolean)Config.minimalHud.get()).booleanValue()) {
            event.setCanceled(true);
            this.redrawAir(event);
        }
        if (event.getOverlay() == ForgeIngameGui.PLAYER_HEALTH_ELEMENT) {
            if (((Boolean)Config.minimalHud.get()).booleanValue()) {
                event.setCanceled(true);
                this.redrawHealth(event);
            } else if (((Boolean)Config.hideHud.get()).booleanValue()) {
                event.setCanceled(true);
            }
        }
    }

    private void redrawArmor(RenderGameOverlayEvent.PreLayer event) {
        this.minecraft.m_91307_().m_6180_("armor");
        RenderSystem.m_69478_();
        int top = this.minecraft.m_91268_().m_85446_() - 49;
        int left = this.minecraft.m_91268_().m_85445_() / 2;
        left = ((Boolean)Config.minimalHud.get()).booleanValue() ? (left -= 91) : (left += 10);
        int armor = this.minecraft.f_91074_.m_21230_();
        if (armor > 0) {
            for (int i = 0; i < 10; ++i) {
                int threshold = i * 2 + 1;
                if (threshold < armor) {
                    this.m_93228_(event.getMatrixStack(), left + i * 8, top, 34, 9, 9, 9);
                    continue;
                }
                if (threshold == armor) {
                    this.m_93228_(event.getMatrixStack(), left + i * 8, top, 25, 9, 9, 9);
                    continue;
                }
                this.m_93228_(event.getMatrixStack(), left + i * 8, top, 16, 9, 9, 9);
            }
        }
        RenderSystem.m_69461_();
        this.minecraft.m_91307_().m_7238_();
    }

    private void redrawAir(RenderGameOverlayEvent.PreLayer event) {
        this.minecraft.m_91307_().m_6180_("air");
        RenderSystem.m_69478_();
        int air = this.minecraft.f_91074_.m_20146_();
        int maxAir = this.minecraft.f_91074_.m_6062_();
        if (this.minecraft.f_91074_.m_19941_((Tag)FluidTags.f_13131_) || air < maxAir) {
            int top = this.minecraft.m_91268_().m_85446_() - 49;
            int left = this.minecraft.m_91268_().m_85445_() / 2 + 91;
            if (this.minecraft.f_91074_.m_21230_() > 0) {
                top -= 10;
            }
            int full = Mth.m_14165_((double)((double)(air - 2) * 10.0 / (double)maxAir));
            int partial = Mth.m_14165_((double)((double)air * 10.0 / (double)maxAir)) - full;
            for (int i = 0; i < full + partial; ++i) {
                if (i < full) {
                    this.m_93228_(event.getMatrixStack(), left - i * 8 - 9, top, 16, 18, 9, 9);
                    continue;
                }
                this.m_93228_(event.getMatrixStack(), left - i * 8 - 9, top, 25, 18, 9, 9);
            }
        }
        RenderSystem.m_69461_();
        this.minecraft.m_91307_().m_7238_();
    }

    private void redrawHealth(RenderGameOverlayEvent.PreLayer event) {
        int absHealth;
        RenderSystem.m_157456_((int)0, (ResourceLocation)Gui.f_93098_);
        this.minecraft.m_91307_().m_6180_("health");
        RenderSystem.m_69478_();
        int top = this.minecraft.m_91268_().m_85446_() - 39;
        int left = this.minecraft.m_91268_().m_85445_() / 2 - 91;
        LocalPlayer player = this.minecraft.f_91074_;
        int health = Mth.m_14167_((float)player.m_21223_());
        boolean flash = this.healthUpdateCounter > (long)this.minecraft.f_91065_.m_93079_() && (this.healthUpdateCounter - (long)this.minecraft.f_91065_.m_93079_()) / 3L % 2L == 1L;
        long time = Util.m_137550_();
        if (health < this.playerHealth && player.f_19802_ > 0) {
            this.lastSystemTime = time;
            this.healthUpdateCounter = this.minecraft.f_91065_.m_93079_() + 20;
        } else if (health > this.playerHealth && player.f_19802_ > 0) {
            this.lastSystemTime = time;
            this.healthUpdateCounter = this.minecraft.f_91065_.m_93079_() + 10;
        }
        if (time - this.lastSystemTime > 1000L) {
            this.playerHealth = health;
            this.lastPlayerHealth = health;
            this.lastSystemTime = time;
        }
        this.playerHealth = health;
        this.rand.setSeed((long)this.minecraft.f_91065_.m_93079_() * 312871L);
        int absHealthTemp = absHealth = Mth.m_14167_((float)player.m_6103_());
        int hearts = Mth.m_14167_((float)((player.m_21223_() + (float)absHealth) / 2.0f)) - 1;
        int maxHearts = Mth.m_14167_((float)((player.m_21233_() + (float)absHealth) / 2.0f)) - 1;
        int row = Mth.m_14167_((float)((float)((hearts + 1) * 2) / 20.0f)) - 1;
        int maxRow = Mth.m_14167_((float)((float)((maxHearts + 1) * 2) / 20.0f)) - 1;
        int rowMin = row * 10;
        int rowMax = rowMin + 10;
        int rowPreferred = row == maxRow ? rowMax - (10 - (maxHearts + 1 - rowMin)) : rowMax;
        for (int i = rowMin; i < rowPreferred; ++i) {
            int textureX = 16;
            if (player.m_21023_(MobEffects.f_19614_)) {
                textureX += 36;
            } else if (player.m_21023_(MobEffects.f_19615_)) {
                textureX += 72;
            }
            int regen = -1;
            if (player.m_21023_(MobEffects.f_19605_)) {
                regen = this.minecraft.f_91065_.m_93079_() % Mth.m_14167_((float)(player.m_21233_() + 5.0f));
            }
            int x = left + i * 8 - 80 * row;
            int y = top;
            if ((double)hearts <= Math.max((double)((Integer)Config.defHealth.get()).intValue() / 2.0 * 0.4, 1.0)) {
                y += this.rand.nextInt(2);
            }
            if (absHealthTemp <= 0 && i == regen) {
                y -= 2;
            }
            this.m_93228_(event.getMatrixStack(), x, y, 16 + (flash ? 9 : 0), 0, 9, 9);
            if (flash) {
                if (i * 2 + 1 < this.lastPlayerHealth) {
                    this.m_93228_(event.getMatrixStack(), x, y, textureX + 54, 0, 9, 9);
                }
                if (i * 2 + 1 == this.lastPlayerHealth) {
                    this.m_93228_(event.getMatrixStack(), x, y, textureX + 63, 0, 9, 9);
                }
            }
            if (i * 2 + 1 < health) {
                this.m_93228_(event.getMatrixStack(), x, y, textureX + 36, 0, 9, 9);
                continue;
            }
            if (i * 2 + 1 == health) {
                this.m_93228_(event.getMatrixStack(), x, y, textureX + 45, 0, 9, 9);
                continue;
            }
            if (i * 2 + 1 <= health || absHealthTemp <= 0) continue;
            if (absHealthTemp == absHealth && absHealth % 2 == 1) {
                this.m_93228_(event.getMatrixStack(), x, y, textureX + 153, 0, 9, 9);
                --absHealthTemp;
                continue;
            }
            this.m_93228_(event.getMatrixStack(), x, y, textureX + 144, 0, 9, 9);
            absHealthTemp -= 2;
        }
        String text = Integer.toString(row + 1);
        if (row >= 9) {
            left -= 6;
        }
        if (row >= 99) {
            left -= 6;
        }
        if (row >= 999) {
            left -= 6;
        }
        if (row >= 9999) {
            text = "9999+";
            left -= 6;
        }
        this.minecraft.f_91062_.m_92883_(event.getMatrixStack(), text, (float)(left - 6), (float)(top + 1), 0);
        this.minecraft.f_91062_.m_92883_(event.getMatrixStack(), text, (float)(left - 8), (float)(top + 1), 0);
        this.minecraft.f_91062_.m_92883_(event.getMatrixStack(), text, (float)(left - 7), (float)(top + 2), 0);
        this.minecraft.f_91062_.m_92883_(event.getMatrixStack(), text, (float)(left - 7), (float)top, 0);
        this.minecraft.f_91062_.m_92883_(event.getMatrixStack(), text, (float)(left - 7), (float)(top + 1), 0xF00000);
        RenderSystem.m_69461_();
        this.minecraft.m_91307_().m_7238_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)Gui.f_93098_);
    }
}

