/*
 * Decompiled with CFR 0.152.
 */
package com.firecontroller1847.levelhearts;

import com.firecontroller1847.levelhearts.LevelHearts;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@net.minecraftforge.common.config.Config(modid="levelhearts", category="levelhearts")
public class Config {
    @Config.Name(value="General")
    public static final General general = new General();
    @Config.Name(value="Health")
    public static final Health health = new Health();
    @Config.Name(value="Gui")
    public static final Gui gui = new Gui();
    @Config.Name(value="Experience")
    public static final Experience experience = new Experience();

    @Mod.EventBusSubscriber(modid="levelhearts")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            LevelHearts.debug("ConfigChanged{Event}");
            if (event.getModID().equals("levelhearts")) {
                ConfigManager.sync((String)"levelhearts", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class Experience {
        @Config.Name(value="XP Multiplier")
        @Config.Comment(value={"How much to multiply the value of experience by."})
        @Config.RangeDouble(min=0.0, max=1024.0)
        public double xpMultiplier = 1.0;
        @Config.Name(value="Always Lose XP on Death")
        @Config.Comment(value={"When enabled, the mod will force players to lose their experience even if the KeepInventory gamerule is enabled."})
        public boolean loseXpOnDeath = false;
        @Config.Name(value="Always Lose Inventory on Death")
        @Config.Comment(value={"When enabled, the mod will force players to lose their items even if the KeepInventory gamerule is enabled.", "If using a setting to lose health upon death, often health will be regained through experience after respawning, which can be confusing."})
        public boolean loseInvOnDeath = false;
    }

    public static class Gui {
        @Config.Name(value="LevelHearts HUD")
        @Config.Comment(value={"When disabled, LevelHearts will not modify the hud at all. Only use if you're having conflicts with other mods."})
        public boolean customHud = true;
        @Config.Name(value="LevelHearts Minimal HUD")
        @Config.Comment(value={"When enabled, the health will display in only one row with a number to the left indicating the row you're on."})
        public boolean minimalHud = false;
        @Config.Name(value="LevelHearts Hidden HUD")
        @Config.Comment(value={"When enabled, health will not be displayed at all. Works well in combination with one-hit knockout."})
        public boolean hideHud = false;
    }

    public static class Health {
        @Config.Name(value="Default Health")
        @Config.Comment(value={"The amount of health a user will have in a new game or after death."})
        @Config.RangeInt(min=1, max=200)
        public int defHealth = 20;
        @Config.Name(value="Maximum Health")
        @Config.Comment(value={"The maximum amount of health LevelHearts will allow a user to have. -1 to disable."})
        @Config.RangeInt(min=-1, max=1024)
        public int maxHealth = -1;
        @Config.Name(value="Level Ramp")
        @Config.Comment(value={"The levels at which a user will gain a heart."})
        public int[] levelRamp = new int[]{1, 5, 10, 15, 20, 25, 30, 34, 38, 42, 46, 50, 53, 56, 59, 62, 64, 66, 68, 70, 75, 80, 85, 90, 95, 100, 110, 120, 130, 140, 150, 160, 170, 180, 190, 200};
        @Config.Name(value="Punish Health")
        @Config.Comment(value={"How many hearts (not health) to take away from the user each time they die. -1 to disable."})
        @Config.RangeInt(min=-1, max=10)
        public int punishAmount = -1;
    }

    public static class General {
        @Config.Name(value="Debug")
        @Config.Comment(value={"When enabled, an extra level of debugging output will be provided to the logs."})
        public boolean enableDebug = false;
        @Config.Name(value="Hardcore")
        @Config.Comment(value={"When enabled, the player's health will get reset back to default on death. Overrides punish amount."})
        public boolean enableHardcore = false;
        @Config.Name(value="Items")
        @Config.Comment(value={"When disabled, LevelHearts' items' functionality will be disabled."})
        public boolean enableItems = true;
        @Config.RequiresWorldRestart
        @Config.Name(value="Loot")
        @Config.Comment(value={"When disabled, LevelHearts will not spawn heart pieces and heart containers in chests around the world."})
        public boolean enableLoot = true;
        @Config.Name(value="Ohko")
        @Config.Comment(value={"When enabled, upon any damage to the player, the player will immediately die. \"One-Hit Knockout\""})
        public boolean enableOhko = false;
    }
}

