/*
 * Decompiled with CFR 0.152.
 */
package com.firecontroller1847.levelhearts;

import com.firecontroller1847.levelhearts.Config;
import com.firecontroller1847.levelhearts.LevelHearts;
import com.firecontroller1847.levelhearts.capabilities.IMoreHealth;
import com.firecontroller1847.levelhearts.capabilities.MoreHealth;
import com.firecontroller1847.levelhearts.capabilities.MoreHealthProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="levelhearts")
public class Events {
    private static int tickDelay = 0;

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.func_130014_f_().field_72995_K) {
            return;
        }
        LevelHearts.debug("PlayerLoggedIn{Event}");
        EntityPlayer player = event.player;
        IMoreHealth cap = MoreHealth.getFromPlayer(player);
        LevelHearts.applyHealthModifier(player, cap.getTrueModifier());
        if (cap.getVersion() == 1) {
            LevelHearts.debug("PlayerLoggedIn{Event}: New player! Initiating data.");
            LevelHearts.debug("PlayerLoggedIn{Event}: Searching for v1 data.");
            NBTTagCompound data = player.getEntityData();
            if (data.func_74764_b("levelHearts")) {
                LevelHearts.debug("PlayerLoggedIn{Event}: Data found. Migrating!");
                NBTTagCompound tag = data.func_74775_l("levelHearts");
                cap.setModifier((float)tag.func_74769_h("modifier"));
                cap.setRampPosition(tag.func_74771_c("levelRampPosition"));
                cap.setHeartContainers(tag.func_74771_c("heartContainers"));
                LevelHearts.applyHealthModifier(player, cap.getTrueModifier());
                data.func_82580_o("levelHearts");
            } else {
                LevelHearts.debug("PlayerLoggedIn{Event}: No v1 data found.");
            }
            player.func_70606_j(player.func_110138_aP());
            cap.setVersion((byte)2);
        }
        cap.setLoggedIn(true);
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            LevelHearts.debug("AttachCapabilities{Event}");
            event.addCapability(new ResourceLocation("levelhearts", "morehealth"), (ICapabilityProvider)new MoreHealthProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        LevelHearts.debug("PlayerClone{Event}");
        EntityPlayer playerOld = event.getOriginal();
        EntityPlayer playerNew = event.getEntityPlayer();
        IMoreHealth capOld = MoreHealth.getFromPlayer(playerOld);
        IMoreHealth capNew = MoreHealth.getFromPlayer(playerNew);
        capNew.copy(capOld);
        if (!event.isWasDeath()) {
            LevelHearts.debug("PlayerClone{Event}: Cloning from dimension change, re-applying health modifier.");
            LevelHearts.applyHealthModifier(playerNew, capNew.getTrueModifier());
            playerNew.func_70606_j(playerOld.func_110143_aJ());
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.player.func_130014_f_().field_72995_K) {
            return;
        }
        LevelHearts.debug("PlayerRespawn{Event}");
        EntityPlayer player = event.player;
        IMoreHealth cap = MoreHealth.getFromPlayer(player);
        if (event.isEndConquered()) {
            LevelHearts.debug("PlayerRespawn{Event}: Coming from end, syncing!");
            MoreHealth.updateClient((EntityPlayerMP)player, cap);
            return;
        }
        if (Config.general.enableHardcore) {
            LevelHearts.debug("PlayerRespawn{Event}: Hardcore mode enabled, removing health.");
            player.func_145747_a((ITextComponent)new TextComponentTranslation("text.levelhearts.hardcore", new Object[0]));
            cap.setModifier(MoreHealth.getDefaultModifier());
            cap.setRampPosition((short)0);
            cap.setHeartContainers((byte)0);
            MoreHealth.updateClient((EntityPlayerMP)player, cap);
        } else if (Config.health.punishAmount > 0) {
            LevelHearts.debug("PlayerRespawn{Event}: Punishment enabled, removing health.");
            int amount = Config.health.punishAmount * 2;
            float oldModifier = cap.getModifier();
            float newModifier = oldModifier - (float)amount;
            if (newModifier < MoreHealth.getDefaultModifier()) {
                float healthLeft = newModifier - MoreHealth.getDefaultModifier();
                byte containers = cap.getHeartContainers();
                byte containersLeft = (byte)Math.max((float)containers + healthLeft / 2.0f, 0.0f);
                cap.setModifier(MoreHealth.getDefaultModifier());
                cap.setRampPosition((short)0);
                cap.setHeartContainers(containersLeft);
                float xpHeartsLost = oldModifier / 2.0f;
                byte containersLost = (byte)(containers - containersLeft);
                int heartsLost = (int)xpHeartsLost + containersLost;
                if (heartsLost > 0) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("text.levelhearts.punish", new Object[]{heartsLost}));
                }
            } else {
                cap.setModifier(newModifier);
                cap.setRampPosition((short)(newModifier / 2.0f));
                player.func_145747_a((ITextComponent)new TextComponentTranslation("text.levelhearts.punish", new Object[]{amount / 2}));
            }
        }
        if (Config.experience.loseXpOnDeath) {
            player.func_82242_a(-player.field_71068_ca - 1);
        }
        LevelHearts.recalcPlayerHealth(player, player.field_71068_ca);
        LevelHearts.applyHealthModifier(player, cap.getTrueModifier());
        player.func_70606_j(player.func_110138_aP());
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        if (event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        LevelHearts.debug("PlayerDamage{Event}");
        if (Config.general.enableOhko) {
            player.func_70606_j(0.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        LevelHearts.debug("PlayerDeath{Event}");
        if (Config.experience.loseInvOnDeath) {
            try {
                ObfuscationReflectionHelper.findMethod(EntityPlayer.class, (String)"destroyVanishingCursedItems", Void.class, (Class[])new Class[0]).invoke((Object)player, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            player.field_71071_by.func_70436_m();
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.player.func_130014_f_().field_72995_K) {
            return;
        }
        LevelHearts.debug("PlayerChangedDimension{Event}");
        EntityPlayer player = event.player;
        IMoreHealth cap = MoreHealth.getFromPlayer(player);
        LevelHearts.applyHealthModifier(player, cap.getTrueModifier());
        cap.synchronise(player);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.func_130014_f_().field_72995_K) {
            return;
        }
        if (++tickDelay >= 10) {
            tickDelay = 0;
            EntityPlayer player = event.player;
            IMoreHealth cap = MoreHealth.getFromPlayer(player);
            if (!cap.isLoggedIn()) {
                return;
            }
            if (cap.getLastKnownExperienceLevel() != player.field_71068_ca) {
                cap.setLastKnownExperienceLevel(player.field_71068_ca);
                LevelHearts.debug("PlayerTick{Event}: Experience level changed!");
                LevelHearts.recalcPlayerHealth(player, player.field_71068_ca);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!(event.getEntity() instanceof EntityXPOrb)) {
            return;
        }
        EntityXPOrb xpOrb = (EntityXPOrb)event.getEntity();
        LevelHearts.debug("XpOrbJoinWorld{Event}");
        xpOrb.field_70530_e = (int)((double)xpOrb.field_70530_e * Config.experience.xpMultiplier);
    }

    @SubscribeEvent
    public static void onExperienceDrop(LivingExperienceDropEvent event) {
        if (Config.experience.loseXpOnDeath && event.getEntity() instanceof EntityPlayer) {
            LevelHearts.debug("ExperienceDrop{Event}");
            EntityPlayer player = (EntityPlayer)event.getEntity();
            int i = player.field_71068_ca * 7;
            event.setDroppedExperience(Math.min(i, 100));
        }
    }
}

