/*
 * Decompiled with CFR 0.152.
 */
package com.firecontroller1847.levelhearts;

import com.firecontroller1847.levelhearts.Config;
import com.firecontroller1847.levelhearts.PacketManager;
import com.firecontroller1847.levelhearts.capabilities.IMoreHealth;
import com.firecontroller1847.levelhearts.capabilities.MoreHealth;
import com.firecontroller1847.levelhearts.capabilities.MoreHealthStorage;
import com.firecontroller1847.levelhearts.commands.LevelHeartsCommand;
import com.firecontroller1847.levelhearts.proxy.IProxy;
import java.util.UUID;
import net.minecraft.command.ICommand;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="levelhearts", name="LevelHearts", version="2.2.0", acceptedMinecraftVersions="[1.12, 1.13)", useMetadata=true)
public class LevelHearts {
    public static final String MOD_ID = "levelhearts";
    public static final String MOD_NAME = "LevelHearts";
    public static final String MOD_VERSION = "2.2.0";
    public static final String MOD_MCVERSION = "[1.12, 1.13)";
    private static final UUID MODIFIER_ID = UUID.fromString("81f27f52-c8bb-403a-a1a4-b356d2f7a0f0");
    private static final Logger logger = LogManager.getLogger((String)"levelhearts");
    @SidedProxy(clientSide="com.firecontroller1847.levelhearts.proxy.ClientProxy", serverSide="com.firecontroller1847.levelhearts.proxy.ServerProxy")
    public static IProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        CapabilityManager.INSTANCE.register(IMoreHealth.class, (Capability.IStorage)new MoreHealthStorage(), MoreHealth::new);
        PacketManager.register();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
    }

    @Mod.EventHandler
    public static void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new LevelHeartsCommand());
    }

    public static void debug(String message) {
        if (Config.general.enableDebug) {
            logger.info(message);
        }
    }

    public static void debug(Object object) {
        LevelHearts.debug(object.toString());
    }

    public static void error(Exception exception) {
        logger.throwing((Throwable)exception);
    }

    public static void applyHealthModifier(EntityPlayer player, double amount) {
        LevelHearts.debug("LevelHearts#applyHealthModifier");
        AttributeModifier modifier = new AttributeModifier(MODIFIER_ID, "levelHearts.healthModifier", amount, 0);
        IAttributeInstance attribute = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        attribute.func_111124_b(modifier);
        attribute.func_111121_a(modifier);
    }

    public static void recalcPlayerHealth(EntityPlayer player, int level) {
        LevelHearts.debug("LevelHearts#calcPlayerHealth");
        IMoreHealth cap = MoreHealth.getFromPlayer(player);
        int[] ramp = Config.health.levelRamp;
        int max = Config.health.maxHealth > 0 ? Config.health.maxHealth : 1024;
        boolean changed = false;
        if (cap.getRampPosition() < 0) {
            cap.setRampPosition((short)0);
        }
        while (cap.getRampPosition() < ramp.length && level >= ramp[cap.getRampPosition()] && player.func_110138_aP() < (float)max) {
            LevelHearts.debug("LevelHearts#calcPlayerHealth: Adding a heart to the player.");
            changed = true;
            cap.addRampPosition();
            cap.setModifier(cap.getModifier() + 2.0f);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("text.levelhearts.heartadded", new Object[0]));
            LevelHearts.applyHealthModifier(player, cap.getTrueModifier());
        }
        if (changed) {
            MoreHealth.updateClient((EntityPlayerMP)player, cap);
            player.func_70606_j(player.func_110138_aP());
        }
    }
}

