/*
 * Decompiled with CFR 0.152.
 */
package com.firecontroller1847.levelhearts;

import com.firecontroller1847.levelhearts.Config;
import com.firecontroller1847.levelhearts.LevelHearts;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class LevelHeartsLoot {
    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (!Config.general.enableLoot) {
            return;
        }
        String[] path = event.getName().func_110623_a().split("/");
        if (path[0].equals("chests")) {
            if (path[1].equals("igloo_chest") || path[1].equals("nether_bridge") || path[1].equals("jungle_temple_dispenser") || path[1].equals("spawn_bonus_chest") || path[1].equals("stronghold_crossing") || path[1].equals("stronghold_library")) {
                return;
            }
            event.getTable().addPool(LevelHeartsLoot.fetchLootPool(String.format("%s/lh_%s", path[0], path[1])));
        }
    }

    public static LootPool fetchLootPool(String location) {
        return LevelHeartsLoot.fetchLootPool("levelhearts:", location);
    }

    public static LootPool fetchLootPool(String namespace, String location) {
        LevelHearts.debug("LootTableLoad{Event}: Creating new loot pool @ " + namespace + location);
        LootEntryTable entry = new LootEntryTable(new ResourceLocation(namespace + location), 1, 1, new LootCondition[0], location);
        return new LootPool(new LootEntry[]{entry}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f), "levelhearts_inject");
    }
}

