/*
 * Decompiled with CFR 0.152.
 */
package com.firecontroller1847.levelhearts.capabilities;

import com.firecontroller1847.levelhearts.Config;
import com.firecontroller1847.levelhearts.PacketManager;
import com.firecontroller1847.levelhearts.capabilities.IMoreHealth;
import com.firecontroller1847.levelhearts.capabilities.MoreHealthProvider;
import com.firecontroller1847.levelhearts.packets.SyncHealthPacket;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityProperties;
import net.minecraft.world.WorldServer;

public class MoreHealth
implements IMoreHealth {
    private byte version = 1;
    private float modifier = MoreHealth.getDefaultModifier();
    private short rampPosition = 0;
    private byte containers;
    private int lastKnownExperienceLevel = 0;
    private boolean loggedIn = false;

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public float getModifier() {
        return this.modifier;
    }

    @Override
    public float getTrueModifier() {
        return this.modifier + (float)(this.containers * 2);
    }

    @Override
    public short getRampPosition() {
        return this.rampPosition;
    }

    @Override
    public byte getHeartContainers() {
        return this.containers;
    }

    @Override
    public void setVersion(byte version) {
        this.version = version;
    }

    @Override
    public void setModifier(float modifier) {
        this.modifier = modifier;
    }

    @Override
    public void setRampPosition(short position) {
        this.rampPosition = position;
    }

    @Override
    public void addRampPosition() {
        this.rampPosition = (short)(this.rampPosition + 1);
    }

    @Override
    public void setHeartContainers(byte amount) {
        this.containers = amount;
    }

    @Override
    public void addHeartContainer() {
        this.containers = (byte)(this.containers + 1);
    }

    @Override
    public int getLastKnownExperienceLevel() {
        return this.lastKnownExperienceLevel;
    }

    @Override
    public void setLastKnownExperienceLevel(int lastKnownExperienceLevel) {
        this.lastKnownExperienceLevel = lastKnownExperienceLevel;
    }

    @Override
    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    @Override
    public void setLoggedIn(boolean loggedIn) {
        this.loggedIn = loggedIn;
    }

    @Override
    public void copy(IMoreHealth other) {
        this.setVersion(other.getVersion());
        this.setModifier(other.getModifier());
        this.setRampPosition(other.getRampPosition());
        this.setHeartContainers(other.getHeartContainers());
        this.setLastKnownExperienceLevel(other.getLastKnownExperienceLevel());
        this.setLoggedIn(other.isLoggedIn());
    }

    @Override
    public void synchronise(EntityPlayer player) {
        if (!player.func_130014_f_().field_72995_K) {
            IAttributeInstance attribute = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
            SPacketEntityProperties packet = new SPacketEntityProperties(player.func_145782_y(), Collections.singleton(attribute));
            ((WorldServer)player.func_130014_f_()).func_73039_n().func_151248_b((Entity)player, (Packet)packet);
        }
    }

    public static float getDefaultModifier() {
        return (float)Config.health.defHealth - (float)SharedMonsterAttributes.field_111267_a.func_111110_b();
    }

    public static IMoreHealth getFromPlayer(EntityPlayer player) {
        return (IMoreHealth)Objects.requireNonNull(player.getCapability(MoreHealthProvider.CAPABILITY, null), "Capability must not be null!");
    }

    public static void updateClient(EntityPlayerMP player, IMoreHealth cap) {
        PacketManager.sendTo(player, new SyncHealthPacket(player.func_145782_y(), (NBTTagCompound)MoreHealthProvider.CAPABILITY.writeNBT((Object)cap, null)));
    }

    public String toString() {
        return String.format("MoreHealth{version=%s,modifier=%s,rampPosition=%s, containers=%s}", this.version, Float.valueOf(this.modifier), this.rampPosition, this.containers);
    }
}

