/*
 * Decompiled with CFR 0.152.
 */
package com.firecontroller1847.levelhearts.commands;

import com.firecontroller1847.levelhearts.LevelHearts;
import com.firecontroller1847.levelhearts.capabilities.IMoreHealth;
import com.firecontroller1847.levelhearts.capabilities.MoreHealth;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class LevelHeartsCommand
extends CommandBase {
    private static final String USAGE_STRING = "/levelhearts <hearts|containers> <add|set> <targets> <amount> [heal:(true)|false]";

    public String func_71517_b() {
        return "levelhearts";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return USAGE_STRING;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length <= 2) {
            throw new WrongUsageException(USAGE_STRING, new Object[0]);
        }
        String arg0 = args[0];
        if (arg0.equalsIgnoreCase("hearts")) {
            String arg1 = args[1];
            if (arg1.equalsIgnoreCase("add")) {
                EntityPlayerMP player = LevelHeartsCommand.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[2]);
                if (args.length <= 3) {
                    throw new WrongUsageException(USAGE_STRING, new Object[0]);
                }
                int arg3 = LevelHeartsCommand.func_175755_a((String)args[3]);
                boolean arg4 = true;
                if (args.length == 5) {
                    arg4 = LevelHeartsCommand.func_180527_d((String)args[4]);
                }
                this.addHealth(player, arg3, arg4);
                return;
            } else {
                if (!arg1.equalsIgnoreCase("set")) throw new WrongUsageException(USAGE_STRING, new Object[0]);
                EntityPlayerMP player = LevelHeartsCommand.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[2]);
                if (args.length <= 3) {
                    throw new WrongUsageException(USAGE_STRING, new Object[0]);
                }
                int arg3 = LevelHeartsCommand.func_180528_a((String)args[3], (int)1);
                boolean arg4 = true;
                if (args.length == 5) {
                    arg4 = LevelHeartsCommand.func_180527_d((String)args[4]);
                }
                this.setHealth(player, arg3, arg4);
            }
            return;
        } else {
            if (!arg0.equalsIgnoreCase("containers")) throw new WrongUsageException(USAGE_STRING, new Object[0]);
            String arg1 = args[1];
            if (arg1.equalsIgnoreCase("add")) {
                EntityPlayerMP player = LevelHeartsCommand.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[2]);
                if (args.length <= 3) {
                    throw new WrongUsageException(USAGE_STRING, new Object[0]);
                }
                int arg3 = LevelHeartsCommand.func_175764_a((String)args[3], (int)-127, (int)127);
                boolean arg4 = true;
                if (args.length == 5) {
                    arg4 = LevelHeartsCommand.func_180527_d((String)args[4]);
                }
                this.addContainers(player, arg3, arg4);
                return;
            } else {
                if (!arg1.equalsIgnoreCase("set")) throw new WrongUsageException(USAGE_STRING, new Object[0]);
                EntityPlayerMP player = LevelHeartsCommand.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[2]);
                if (args.length <= 3) {
                    throw new WrongUsageException(USAGE_STRING, new Object[0]);
                }
                int arg3 = LevelHeartsCommand.func_175764_a((String)args[3], (int)0, (int)127);
                boolean arg4 = true;
                if (args.length == 5) {
                    arg4 = LevelHeartsCommand.func_180527_d((String)args[4]);
                }
                this.setContainers(player, arg3, arg4);
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return LevelHeartsCommand.func_71530_a((String[])args, (String[])new String[]{"hearts", "containers"});
        }
        if (args.length == 2) {
            return LevelHeartsCommand.func_71530_a((String[])args, (String[])new String[]{"add", "set"});
        }
        if (args.length == 3) {
            return LevelHeartsCommand.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 5) {
            return LevelHeartsCommand.func_71530_a((String[])args, (String[])new String[]{"true", "false"});
        }
        return Collections.emptyList();
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 1;
    }

    private void addHealth(EntityPlayerMP targetPlayer, int amount, boolean heal) {
        LevelHearts.debug("LevelHeartsCommand#addHealth: Adding " + amount * 2 + " health!");
        IMoreHealth cap = MoreHealth.getFromPlayer((EntityPlayer)targetPlayer);
        float newModifier = cap.getModifier() + (float)(amount * 2);
        if (newModifier <= -((float)SharedMonsterAttributes.field_111267_a.func_111110_b())) {
            newModifier = amount > 0 ? 1024.0f : -((float)SharedMonsterAttributes.field_111267_a.func_111110_b()) + 2.0f;
        }
        cap.setModifier(newModifier);
        cap.setRampPosition((short)0);
        MoreHealth.updateClient(targetPlayer, cap);
        LevelHearts.applyHealthModifier((EntityPlayer)targetPlayer, cap.getTrueModifier());
        if (heal) {
            targetPlayer.func_70606_j(targetPlayer.func_110138_aP());
        } else {
            targetPlayer.func_70606_j(targetPlayer.func_110143_aJ() - 1.0f);
            targetPlayer.func_70606_j(targetPlayer.func_110143_aJ() + 1.0f);
        }
    }

    private void setHealth(EntityPlayerMP targetPlayer, int amount, boolean heal) {
        LevelHearts.debug("LevelHeartsCommand#addHealth: Setting health to " + amount * 2 + "!");
        IMoreHealth cap = MoreHealth.getFromPlayer((EntityPlayer)targetPlayer);
        cap.setModifier((float)(amount * 2) - (float)SharedMonsterAttributes.field_111267_a.func_111110_b());
        cap.setRampPosition((short)0);
        MoreHealth.updateClient(targetPlayer, cap);
        LevelHearts.applyHealthModifier((EntityPlayer)targetPlayer, cap.getTrueModifier());
        if (heal) {
            targetPlayer.func_70606_j(targetPlayer.func_110138_aP());
        } else {
            targetPlayer.func_70606_j(targetPlayer.func_110143_aJ() - 1.0f);
            targetPlayer.func_70606_j(targetPlayer.func_110143_aJ() + 1.0f);
        }
    }

    private void addContainers(EntityPlayerMP targetPlayer, int amount, boolean heal) {
        LevelHearts.debug("LevelHeartsCommand#addHealth: Adding " + amount + " heart containers!");
        IMoreHealth cap = MoreHealth.getFromPlayer((EntityPlayer)targetPlayer);
        int newContainers = cap.getHeartContainers() + amount;
        if (newContainers < 0) {
            newContainers = amount > 0 ? 127 : 0;
        }
        cap.setHeartContainers((byte)newContainers);
        MoreHealth.updateClient(targetPlayer, cap);
        LevelHearts.applyHealthModifier((EntityPlayer)targetPlayer, cap.getTrueModifier());
        if (heal) {
            targetPlayer.func_70606_j(targetPlayer.func_110138_aP());
        } else {
            targetPlayer.func_70606_j(targetPlayer.func_110143_aJ() - 1.0f);
            targetPlayer.func_70606_j(targetPlayer.func_110143_aJ() + 1.0f);
        }
    }

    private void setContainers(EntityPlayerMP targetPlayer, int amount, boolean heal) {
        LevelHearts.debug("LevelHeartsCommand#addHealth: Setting heart containers to " + amount + "!");
        IMoreHealth cap = MoreHealth.getFromPlayer((EntityPlayer)targetPlayer);
        cap.setHeartContainers((byte)amount);
        MoreHealth.updateClient(targetPlayer, cap);
        LevelHearts.applyHealthModifier((EntityPlayer)targetPlayer, cap.getTrueModifier());
        if (heal) {
            targetPlayer.func_70606_j(targetPlayer.func_110138_aP());
        } else {
            targetPlayer.func_70606_j(targetPlayer.func_110143_aJ() - 1.0f);
            targetPlayer.func_70606_j(targetPlayer.func_110143_aJ() + 1.0f);
        }
    }
}

