/*
 * Decompiled with CFR 0.152.
 */
package com.firecontroller1847.levelhearts;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraftforge.common.ForgeConfigSpec;

public class LevelHeartsConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER);
    public static final Health HEALTH = new Health(BUILDER);
    public static final Gui GUI = new Gui(BUILDER);
    public static final Xp XP = new Xp(BUILDER);
    public static final ForgeConfigSpec COMMON = BUILDER.build();

    public static class Xp {
        public final ForgeConfigSpec.ConfigValue<Double> multiplier;
        public final ForgeConfigSpec.ConfigValue<Boolean> loseOnDeath;

        public Xp(ForgeConfigSpec.Builder builder) {
            builder.push("Xp");
            this.multiplier = builder.comment("How much to multiply the value of XP by.").defineInRange("XP Multiplier", 1.0, 0.0, 127.0);
            this.loseOnDeath = builder.comment("Force players to lose their XP even if keepInventory is enabled.").define("Always Lose XP on Death", false);
            builder.pop();
        }
    }

    public static class Gui {
        public final ForgeConfigSpec.ConfigValue<Boolean> hud;
        public final ForgeConfigSpec.ConfigValue<Boolean> minimalHud;

        public Gui(ForgeConfigSpec.Builder builder) {
            builder.push("Gui");
            this.hud = builder.comment(" Whether or not to use the custom HUD provided by LevelHearts. Only disable if you're having mod conflicts.").define("LevelHearts HUD", true);
            this.minimalHud = builder.comment(" Changes the HUD to display health in one-row only.").define("LevelHearts Minimal HUD", false);
            builder.pop();
        }
    }

    public static class Health {
        public final ForgeConfigSpec.ConfigValue<Integer> defHealth;
        public final ForgeConfigSpec.ConfigValue<Integer> maxHealth;
        public final ForgeConfigSpec.ConfigValue<ArrayList<Integer>> levelRamp;

        public Health(ForgeConfigSpec.Builder builder) {
            builder.push("Health");
            this.defHealth = builder.comment(" The amount of half-hearts a user will have in a new game and after death.").defineInRange("Default Health", 20, 1, 127);
            this.maxHealth = builder.comment(" The maximum amount of half-hearts a user can have.").defineInRange("Maximum Health", -1, -1, Short.MAX_VALUE);
            this.levelRamp = builder.comment(" The levels at which the user will gain a heart.").define("Level Ramp", new ArrayList<Integer>(Arrays.asList(1, 5, 10, 15, 20, 25, 30, 34, 38, 42, 46, 50, 53, 56, 59, 62, 64, 66, 68, 70, 75, 80, 85, 90, 95, 100, 110, 120, 130, 140, 150, 160, 170, 180, 190, 200)));
            builder.pop();
        }
    }

    public static class General {
        public final ForgeConfigSpec.ConfigValue<Boolean> debug;
        public final ForgeConfigSpec.ConfigValue<Boolean> hardcore;

        public General(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.debug = builder.comment(" Provides more output to the log. Mostly used for development and debugging.").define("Debug", false);
            this.hardcore = builder.comment(" Resets the player's progress after death.").define("Hardcore", false);
            builder.pop();
        }
    }
}

