/*
 * Decompiled with CFR 0.152.
 */
package com.firecontroller1847.levelhearts.gui;

import com.firecontroller1847.levelhearts.LevelHeartsConfig;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class LevelHeartsHUD
extends Gui {
    private Minecraft mc;
    protected final Random rand = new Random();
    long healthUpdateCounter;
    int playerHealth;
    int lastPlayerHealth;
    long lastSystemTime;

    public LevelHeartsHUD() {
        this.mc = Minecraft.func_71410_x();
    }

    @SubscribeEvent
    public void modifyPlayerStats(RenderGameOverlayEvent.Pre event) {
        if (!((Boolean)LevelHeartsConfig.GUI.hud.get()).booleanValue()) {
            return;
        }
        RenderGameOverlayEvent.ElementType type = event.getType();
        if (type == RenderGameOverlayEvent.ElementType.ARMOR) {
            event.setCanceled(true);
            this.redrawArmor();
        } else if (type == RenderGameOverlayEvent.ElementType.AIR && !((Boolean)LevelHeartsConfig.GUI.minimalHud.get()).booleanValue()) {
            event.setCanceled(true);
            this.redrawAir();
        } else if (type == RenderGameOverlayEvent.ElementType.HEALTH && ((Boolean)LevelHeartsConfig.GUI.minimalHud.get()).booleanValue()) {
            event.setCanceled(true);
            this.redrawHealth();
        }
    }

    private void redrawArmor() {
        if (!(this.mc.func_175606_aa() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)this.mc.func_175606_aa();
        int left = this.mc.field_195558_d.func_198107_o() / 2;
        left = ((Boolean)LevelHeartsConfig.GUI.minimalHud.get()).booleanValue() ? (left -= 91) : (left += 10);
        int top = this.mc.field_195558_d.func_198087_p() - 49;
        int armor = player.func_70658_aO();
        if (armor <= 0) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            int threshold = i * 2 + 1;
            if (threshold < armor) {
                this.func_73729_b(left + i * 8, top, 34, 9, 9, 9);
                continue;
            }
            if (threshold == armor) {
                this.func_73729_b(left + i * 8, top, 25, 9, 9, 9);
                continue;
            }
            this.func_73729_b(left + i * 8, top, 16, 9, 9, 9);
        }
    }

    private void redrawAir() {
        if (!(this.mc.func_175606_aa() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)this.mc.func_175606_aa();
        int air = player.func_70086_ai();
        int maxAir = player.func_205010_bg();
        if (!player.func_208600_a(FluidTags.field_206959_a) && air >= maxAir) {
            return;
        }
        int left = this.mc.field_195558_d.func_198107_o() / 2 + 91;
        int top = this.mc.field_195558_d.func_198087_p() - 49;
        if (player.func_70658_aO() > 0) {
            top -= 10;
        }
        int current = MathHelper.func_76143_f((double)((double)(air - 2) * 10.0 / (double)maxAir));
        int changed = MathHelper.func_76143_f((double)((double)air * 10.0 / (double)maxAir)) - current;
        for (int i = 0; i < current + changed; ++i) {
            if (i < current) {
                this.func_73729_b(left - i * 8 - 9, top, 16, 18, 9, 9);
                continue;
            }
            this.func_73729_b(left - i * 8 - 9, top, 25, 18, 9, 9);
        }
    }

    private void redrawHealth() {
        int absHealth;
        if (!(this.mc.func_175606_aa() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)this.mc.func_175606_aa();
        int left = this.mc.field_195558_d.func_198107_o() / 2 - 91;
        int top = this.mc.field_195558_d.func_198087_p() - 39;
        int health = MathHelper.func_76123_f((float)player.func_110143_aJ());
        boolean flash = this.healthUpdateCounter > (long)this.mc.field_71456_v.func_73834_c() && (this.healthUpdateCounter - (long)this.mc.field_71456_v.func_73834_c()) / 3L % 2L == 1L;
        long time = Util.func_211177_b();
        if (health < this.playerHealth && player.field_70172_ad > 0) {
            this.lastSystemTime = time;
            this.healthUpdateCounter = this.mc.field_71456_v.func_73834_c() + 20;
        } else if (health > this.playerHealth && player.field_70172_ad > 0) {
            this.lastSystemTime = time;
            this.healthUpdateCounter = this.mc.field_71456_v.func_73834_c() + 10;
        }
        if (time - this.lastSystemTime > 1000L) {
            this.playerHealth = health;
            this.lastPlayerHealth = health;
            this.lastSystemTime = time;
        }
        this.playerHealth = health;
        this.rand.setSeed(this.mc.field_71456_v.func_73834_c());
        int absHealthTemp = absHealth = MathHelper.func_76123_f((float)player.func_110139_bj());
        int hearts = MathHelper.func_76123_f((float)((player.func_110143_aJ() + (float)absHealth) / 2.0f)) - 1;
        int maxHearts = MathHelper.func_76123_f((float)((player.func_110138_aP() + (float)absHealth) / 2.0f)) - 1;
        int row = MathHelper.func_76123_f((float)((float)((hearts + 1) * 2) / 20.0f)) - 1;
        int maxRow = MathHelper.func_76123_f((float)((float)((maxHearts + 1) * 2) / 20.0f)) - 1;
        int rowMin = row * 10;
        int rowMax = rowMin + 10;
        int rowPreferred = row == maxRow ? rowMax - (10 - (maxHearts + 1 - rowMin)) : rowMax;
        for (int i = rowMin; i < rowPreferred; ++i) {
            int textureX = 16;
            if (player.func_70644_a(MobEffects.field_76436_u)) {
                textureX += 36;
            } else if (player.func_70644_a(MobEffects.field_82731_v)) {
                textureX += 72;
            }
            int regen = -1;
            if (player.func_70644_a(MobEffects.field_76428_l)) {
                regen = this.mc.field_71456_v.func_73834_c() % MathHelper.func_76123_f((float)(player.func_110138_aP() + 5.0f));
            }
            int x = left + i * 8 - 80 * row;
            int y = top;
            if (hearts <= 4) {
                y += this.rand.nextInt(2);
            }
            if (absHealthTemp <= 0 && i == regen) {
                y -= 2;
            }
            this.func_73729_b(x, y, 16 + 1 * (flash ? 9 : 0), 0, 9, 9);
            if (flash) {
                if (i * 2 + 1 < this.lastPlayerHealth) {
                    this.func_73729_b(x, y, textureX + 54, 0, 9, 9);
                }
                if (i * 2 + 1 == this.lastPlayerHealth) {
                    this.func_73729_b(x, y, textureX + 63, 0, 9, 9);
                }
            }
            if (i * 2 + 1 < health) {
                this.func_73729_b(x, y, textureX + 36, 0, 9, 9);
                continue;
            }
            if (i * 2 + 1 == health) {
                this.func_73729_b(x, y, textureX + 45, 0, 9, 9);
                continue;
            }
            if (i * 2 + 1 <= health || absHealthTemp <= 0) continue;
            if (absHealthTemp == absHealth && absHealth % 2 == 1) {
                this.func_73729_b(x, y, textureX + 153, 0, 9, 9);
                --absHealthTemp;
                continue;
            }
            this.func_73729_b(x, y, textureX + 144, 0, 9, 9);
            absHealthTemp -= 2;
        }
        String text = Integer.toString(row + 1);
        if (row >= 9) {
            left -= 6;
        }
        if (row >= 99) {
            left -= 6;
        }
        if (row >= 999) {
            left -= 6;
        }
        if (row >= 9999) {
            text = "9999+";
            left -= 6;
        }
        this.mc.field_71466_p.func_211126_b(text, (float)(left - 6), (float)(top + 1), 0);
        this.mc.field_71466_p.func_211126_b(text, (float)(left - 8), (float)(top + 1), 0);
        this.mc.field_71466_p.func_211126_b(text, (float)(left - 7), (float)(top + 2), 0);
        this.mc.field_71466_p.func_211126_b(text, (float)(left - 7), (float)top, 0);
        this.mc.field_71466_p.func_211126_b(text, (float)(left - 7), (float)(top + 1), 0xF00000);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
    }
}

