/*
 * Decompiled with CFR 0.152.
 */
package com.firecontroller1847.levelhearts.player;

import com.firecontroller1847.levelhearts.LevelHeartsConfig;
import com.mojang.authlib.GameProfile;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerData {
    private static ConcurrentHashMap<String, PlayerData> datas = new ConcurrentHashMap();
    protected boolean hasRunLogin = false;
    protected int cachedLevel;
    public byte heartContainers;
    protected byte defHealth;
    protected double modifier;
    protected short levelRampPosition;

    public PlayerData() {
        this(true);
    }

    public PlayerData(boolean empty) {
        if (empty) {
            return;
        }
        this.defHealth = ((Integer)LevelHeartsConfig.HEALTH.defHealth.get()).byteValue();
        this.modifier = (double)this.defHealth - SharedMonsterAttributes.field_111267_a.func_111110_b();
        this.heartContainers = 0;
        this.levelRampPosition = 0;
    }

    public double getModifierWithHeartContainers() {
        return this.modifier + (double)(this.heartContainers * 2);
    }

    public PlayerData loadFromPlayer(EntityPlayer player) {
        NBTTagCompound entityTags = player.getEntityData();
        if (!entityTags.func_74764_b("levelHearts")) {
            return null;
        }
        NBTTagCompound tag = entityTags.func_74775_l("levelHearts");
        this.defHealth = tag.func_74771_c("defHealth");
        this.modifier = tag.func_74769_h("modifier");
        this.heartContainers = tag.func_74771_c("heartContainers");
        this.levelRampPosition = tag.func_74765_d("levelRampPosition");
        return this;
    }

    public void saveToPlayer(EntityPlayer player) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("minHealth", this.defHealth);
        tag.func_74780_a("modifier", this.modifier);
        tag.func_74774_a("heartContainers", this.heartContainers);
        tag.func_74777_a("levelRampPosition", this.levelRampPosition);
        player.getEntityData().func_74782_a("levelHearts", (INBTBase)tag);
    }

    public static PlayerData getCachedPlayerData(EntityPlayer player) {
        return datas.get(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()).toString());
    }

    public static void removeCachedPlayerData(EntityPlayer player) {
        datas.remove(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()).toString());
    }

    public static void cachePlayerData(EntityPlayer player, PlayerData data) {
        datas.put(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()).toString(), data);
    }

    public String toString() {
        return "PlayerData{minHealth=" + this.defHealth + ", modifier=" + this.modifier + ", cachedLevel=" + this.cachedLevel + "}";
    }
}

