/*
 * Decompiled with CFR 0.152.
 */
package com.firecontroller1847.levelhearts.player;

import com.firecontroller1847.levelhearts.LevelHearts;
import com.firecontroller1847.levelhearts.LevelHeartsConfig;
import com.firecontroller1847.levelhearts.player.PlayerData;
import java.util.ArrayList;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="levelhearts")
public class PlayerEvents {
    private static int tickDelay = 0;

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (((Boolean)LevelHeartsConfig.GENERAL.debug.get()).booleanValue()) {
            LevelHearts.logger.info("PlayerLoggedIn{Event}");
        }
        PlayerData data = new PlayerData().loadFromPlayer(event.getPlayer());
        if (((Boolean)LevelHeartsConfig.GENERAL.debug.get()).booleanValue()) {
            LevelHearts.logger.info("PlayerLoggedIn{Event}: Searching for previous playerdata...");
        }
        if (data == null) {
            if (((Boolean)LevelHeartsConfig.GENERAL.debug.get()).booleanValue()) {
                LevelHearts.logger.info("PlayerLoggedIn{Event}: No data found for player, creating new data");
            }
            data = new PlayerData(false);
            data.saveToPlayer(event.getPlayer());
            PlayerEvents.setHealthModifier(event.getPlayer(), data.getModifierWithHeartContainers());
            event.getPlayer().func_70606_j(event.getPlayer().func_110138_aP());
            if (((Boolean)LevelHeartsConfig.GENERAL.debug.get()).booleanValue()) {
                LevelHearts.logger.info("PlayerLoggedIn{Event}: The following data has been saved to the player " + data);
            }
        } else {
            if (((Boolean)LevelHeartsConfig.GENERAL.debug.get()).booleanValue()) {
                LevelHearts.logger.info("PlayerLoggedIn{Event}: Found previous playerdata " + data);
            }
            PlayerEvents.setHealthModifier(event.getPlayer(), data.getModifierWithHeartContainers());
        }
        data.hasRunLogin = true;
        PlayerData.cachePlayerData(event.getPlayer(), data);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (++tickDelay < 10) {
            return;
        }
        tickDelay = 0;
        PlayerData data = PlayerData.getCachedPlayerData(event.player);
        if (data != null && data.hasRunLogin && PlayerEvents.hasLevelChanged(event.player, data)) {
            if (((Boolean)LevelHeartsConfig.GENERAL.debug.get()).booleanValue()) {
                LevelHearts.logger.info("PlayerTick{Event}: Player's level has changed!");
            }
            ArrayList ramp = (ArrayList)LevelHeartsConfig.HEALTH.levelRamp.get();
            int max = (Integer)LevelHeartsConfig.HEALTH.maxHealth.get();
            while (data.levelRampPosition < ramp.size() && event.player.field_71068_ca >= (Integer)ramp.get(data.levelRampPosition) && (max <= 0 || event.player.func_110138_aP() < (float)max)) {
                event.player.func_145747_a((ITextComponent)new TextComponentTranslation("text.levelhearts.heartadded", new Object[0]));
                data.levelRampPosition = (short)(data.levelRampPosition + 1);
                data.modifier += 2.0;
                PlayerData.cachePlayerData(event.player, data);
                PlayerEvents.setHealthModifier(event.player, data.getModifierWithHeartContainers());
                event.player.func_70606_j(event.player.func_110138_aP());
                if (!((Boolean)LevelHeartsConfig.GENERAL.debug.get()).booleanValue()) continue;
                LevelHearts.logger.info("PlayerTick{Event}: XP matches next level ramp. Player's health has increased by 1");
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (((Boolean)LevelHeartsConfig.GENERAL.debug.get()).booleanValue()) {
            LevelHearts.logger.info("PlayerRespawn{Event}");
        }
        PlayerData data = PlayerData.getCachedPlayerData(event.getPlayer());
        if (((Boolean)LevelHeartsConfig.GENERAL.hardcore.get()).booleanValue()) {
            data.heartContainers = 0;
            data.levelRampPosition = 0;
            data.modifier = (double)((Integer)LevelHeartsConfig.HEALTH.defHealth.get()).intValue() - SharedMonsterAttributes.field_111267_a.func_111110_b();
            PlayerData.cachePlayerData(event.getPlayer(), data);
        }
        if (((Boolean)LevelHeartsConfig.XP.loseOnDeath.get()).booleanValue()) {
            event.getPlayer().func_82242_a(-(event.getPlayer().field_71068_ca + 1));
        }
        PlayerEvents.setHealthModifier(event.getPlayer(), data.getModifierWithHeartContainers());
        event.getPlayer().func_70606_j(event.getPlayer().func_110138_aP());
    }

    @SubscribeEvent
    public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        if (!((Boolean)LevelHeartsConfig.XP.loseOnDeath.get()).booleanValue() || !(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        if (((Boolean)LevelHeartsConfig.GENERAL.debug.get()).booleanValue()) {
            LevelHearts.logger.info("LivingExperienceDrop{Event}");
        }
        if (((Boolean)LevelHeartsConfig.GENERAL.debug.get()).booleanValue()) {
            LevelHearts.logger.info("LivingExperienceDrop{Event}: droppedExperience=" + event.getDroppedExperience());
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        int i = player.field_71068_ca * 7;
        event.setDroppedExperience(i > 100 ? 100 : i);
        if (((Boolean)LevelHeartsConfig.GENERAL.debug.get()).booleanValue()) {
            LevelHearts.logger.info("LivingExperienceDropEvent{Event}: droppedExperience=" + event.getDroppedExperience());
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (((Boolean)LevelHeartsConfig.GENERAL.debug.get()).booleanValue()) {
            LevelHearts.logger.info("PlayerChangedDimension{Event}");
        }
        PlayerData data = PlayerData.getCachedPlayerData(event.getPlayer());
        PlayerEvents.setHealthModifier(event.getPlayer(), data.getModifierWithHeartContainers());
    }

    @SubscribeEvent
    public static void onPlayerPickupXp(PlayerPickupXpEvent event) {
        if (((Boolean)LevelHeartsConfig.GENERAL.debug.get()).booleanValue()) {
            LevelHearts.logger.info("PlayerPickupXpEvent{Event}");
        }
        event.getOrb().field_70530_e = (int)((double)event.getOrb().field_70530_e * (Double)LevelHeartsConfig.XP.multiplier.get());
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerData data;
        if (((Boolean)LevelHeartsConfig.GENERAL.debug.get()).booleanValue()) {
            LevelHearts.logger.info("PlayedLoggedOut{Event}");
        }
        if ((data = PlayerData.getCachedPlayerData(event.getPlayer())) != null) {
            data.saveToPlayer(event.getPlayer());
            if (((Boolean)LevelHeartsConfig.GENERAL.debug.get()).booleanValue()) {
                LevelHearts.logger.info("PlayerLoggedOut{Event}: Saved player data");
            }
        }
        PlayerData.removeCachedPlayerData(event.getPlayer());
    }

    private static boolean hasLevelChanged(EntityPlayer player, PlayerData data) {
        boolean changed = false;
        if (data.cachedLevel != player.field_71068_ca) {
            data.cachedLevel = player.field_71068_ca;
            changed = true;
        }
        return changed;
    }

    public static void setHealthModifier(EntityPlayer player, double modifier) {
        LevelHearts.healthModifier = new AttributeModifier(LevelHearts.MOD_UUID, "levelHearts.healthModifier", modifier, 0);
        IAttributeInstance attribute = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        attribute.func_111124_b(LevelHearts.healthModifier);
        attribute.func_111121_a(LevelHearts.healthModifier);
        player.func_70606_j(player.func_110143_aJ() - 1.0f);
        player.func_70606_j(player.func_110143_aJ() + 1.0f);
    }
}

