/*
 * Decompiled with CFR 0.152.
 */
package com.firecontroller1847.levelhearts;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    public static final ForgeConfigSpec SPEC = Config.build();
    public static ForgeConfigSpec.ConfigValue<Boolean> enableDebug;
    public static ForgeConfigSpec.ConfigValue<Boolean> enableHardcore;
    public static ForgeConfigSpec.ConfigValue<Boolean> enableItems;
    public static ForgeConfigSpec.ConfigValue<Boolean> enableLoot;
    public static ForgeConfigSpec.ConfigValue<Boolean> enableOhko;
    public static ForgeConfigSpec.ConfigValue<Integer> defHealth;
    public static ForgeConfigSpec.ConfigValue<Integer> maxHealth;
    public static ForgeConfigSpec.ConfigValue<ArrayList<Integer>> levelRamp;
    public static ForgeConfigSpec.ConfigValue<Integer> punishAmount;
    public static ForgeConfigSpec.ConfigValue<Boolean> customHud;
    public static ForgeConfigSpec.ConfigValue<Boolean> minimalHud;
    public static ForgeConfigSpec.ConfigValue<Boolean> hideHud;
    public static ForgeConfigSpec.ConfigValue<Double> xpMultiplier;
    public static ForgeConfigSpec.ConfigValue<Boolean> loseXpOnDeath;
    public static ForgeConfigSpec.ConfigValue<Boolean> loseInvOnDeath;

    private static final ForgeConfigSpec build() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("General");
        enableDebug = builder.comment("When enabled, an extra level of debugging output will be provided to the logs.").define("Debug", false);
        enableHardcore = builder.comment("When enabled, the player's health will get reset back to default on death. Overrides punish amount.").define("Hardcore", false);
        enableItems = builder.comment("When disabled, LevelHearts' items' functionality will be disabled.").define("Items", true);
        enableLoot = builder.comment("When disabled, LevelHearts will not spawn heart pieces and heart containers in chests around the world.").define("Loot", true);
        enableOhko = builder.comment("When enabled, upon any damage to the player, the player will immediately die. \"One-Hit Knockout\"").define("Ohko", false);
        builder.pop();
        builder.push("Health");
        defHealth = builder.comment("The amount of health a user will have in a new game or after death.").defineInRange("Default Health", 20, 1, 200);
        maxHealth = builder.comment("The maximum amount of health LevelHearts will allow a user to have. -1 to disable.").defineInRange("Maximum Health", -1, -1, 1024);
        levelRamp = builder.comment("The levels at which a user will gain a heart.").define("Level Ramp", new ArrayList<Integer>(Arrays.asList(1, 5, 10, 15, 20, 25, 30, 34, 38, 42, 46, 50, 53, 56, 59, 62, 64, 66, 68, 70, 75, 80, 85, 90, 95, 100, 110, 120, 130, 140, 150, 160, 170, 180, 190, 200)));
        punishAmount = builder.comment("How many hearts (not health) to take away from the user each time they die. -1 to disable.").defineInRange("Punish Health", -1, -1, 10);
        builder.pop();
        builder.push("Gui");
        customHud = builder.comment("When disabled, LevelHearts will not modify the hud at all. Only use if you're having conflicts with other mods.").define("LevelHearts HUD", true);
        minimalHud = builder.comment("When enabled, the health will display in only one row with a number to the left indicating the row you're on.").define("LevelHearts Minimal HUD", false);
        hideHud = builder.comment("When enabled, health will not be displayed at all. Works well in combination with one-hit knockout.").define("LevelHearts Hidden HUD", false);
        builder.pop();
        builder.push("Experience");
        xpMultiplier = builder.comment("How much to multiply the value of experience by.").defineInRange("XP Multiplier", 1.0, 0.0, 1024.0);
        loseXpOnDeath = builder.comment("When enabled, the mod will force players to lose their experience even if the KeepInventory gamerule is enabled.").define("Always Lose XP on Death", false);
        loseInvOnDeath = builder.comment(new String[]{"When enabled, the mod will force players to lose their items even if the KeepInventory gamerule is enabled.", "If using a setting to lose health upon death, often health will be regained through experience after respawning, which can be confusing."}).define("Always Lose Inventory on Death", false);
        builder.pop();
        return builder.build();
    }
}

