/*
 * Decompiled with CFR 0.152.
 */
package com.firecontroller1847.levelhearts;

import com.firecontroller1847.levelhearts.Config;
import com.firecontroller1847.levelhearts.LevelHearts;
import com.firecontroller1847.levelhearts.capabilities.IMoreHealth;
import com.firecontroller1847.levelhearts.capabilities.MoreHealth;
import com.firecontroller1847.levelhearts.capabilities.MoreHealthProvider;
import com.firecontroller1847.levelhearts.commands.LevelHeartsCommand;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;

@Mod.EventBusSubscriber(modid="levelhearts", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Events {
    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer().func_130014_f_().field_72995_K) {
            return;
        }
        LevelHearts.debug("PlayerLoggedIn{Event}");
        PlayerEntity player = event.getPlayer();
        IMoreHealth cap = MoreHealth.getFromPlayer(player);
        LevelHearts.applyHealthModifier(player, cap.getTrueModifier());
        if (cap.getVersion() == 1) {
            LevelHearts.debug("PlayerLoggedIn{Event}: New player! Initiating data.");
            LevelHearts.debug("PlayerLoggedIn{Event}: Searching for v1 data.");
            CompoundNBT data = player.getEntity().getPersistentData();
            if (data.func_74764_b("levelHearts")) {
                LevelHearts.debug("PlayerLoggedIn{Event}: Data found. Migrating!");
                CompoundNBT tag = data.func_74775_l("levelHearts");
                cap.setModifier((float)tag.func_74769_h("modifier"));
                cap.setRampPosition(tag.func_74771_c("levelRampPosition"));
                cap.setHeartContainers(tag.func_74771_c("heartContainers"));
                LevelHearts.applyHealthModifier(player, cap.getTrueModifier());
                data.func_82580_o("levelHearts");
            } else {
                LevelHearts.debug("PlayerLoggedIn{Event}: No v1 data found.");
            }
            player.func_70606_j(player.func_110138_aP());
            cap.setVersion((byte)2);
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            LevelHearts.debug("AttachCapabilities{Event}");
            event.addCapability(new ResourceLocation("levelhearts", "morehealth"), (ICapabilityProvider)new MoreHealthProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        LevelHearts.debug("PlayerClone{Event}");
        PlayerEntity playerOld = event.getOriginal();
        PlayerEntity playerNew = event.getPlayer();
        IMoreHealth capOld = MoreHealth.getFromPlayer(playerOld);
        IMoreHealth capNew = MoreHealth.getFromPlayer(playerNew);
        capNew.copy(capOld);
        if (!event.isWasDeath()) {
            LevelHearts.debug("PlayerClone{Event}: Cloning from dimension change, re-applying health modifier.");
            LevelHearts.applyHealthModifier(playerNew, capNew.getTrueModifier());
            playerNew.func_70606_j(playerOld.func_110143_aJ());
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getPlayer().func_130014_f_().field_72995_K) {
            return;
        }
        LevelHearts.debug("PlayerRespawn{Event}");
        PlayerEntity player = event.getPlayer();
        IMoreHealth cap = MoreHealth.getFromPlayer(player);
        if (event.isEndConquered()) {
            LevelHearts.debug("PlayerRespawn{Event}: Coming from end, syncing!");
            MoreHealth.updateClient((ServerPlayerEntity)player, cap);
            return;
        }
        if (((Boolean)Config.enableHardcore.get()).booleanValue()) {
            LevelHearts.debug("PlayerRespawn{Event}: Hardcore mode enabled, removing health.");
            player.func_145747_a((ITextComponent)new TranslationTextComponent("text.levelhearts.hardcore", new Object[0]));
            cap.setModifier(MoreHealth.getDefaultModifier());
            cap.setRampPosition((short)0);
            cap.setHeartContainers((byte)0);
            MoreHealth.updateClient((ServerPlayerEntity)player, cap);
        } else if ((Integer)Config.punishAmount.get() > 0) {
            LevelHearts.debug("PlayerRespawn{Event}: Punishment enabled, removing health.");
            int amount = (Integer)Config.punishAmount.get() * 2;
            float oldModifier = cap.getModifier();
            float newModifier = oldModifier - (float)amount;
            if (newModifier < MoreHealth.getDefaultModifier()) {
                float healthLeft = newModifier - MoreHealth.getDefaultModifier();
                byte containers = cap.getHeartContainers();
                byte containersLeft = (byte)Math.max((float)containers + healthLeft / 2.0f, 0.0f);
                cap.setModifier(MoreHealth.getDefaultModifier());
                cap.setRampPosition((short)0);
                cap.setHeartContainers(containersLeft);
                float xpHeartsLost = oldModifier / 2.0f;
                byte containersLost = (byte)(containers - containersLeft);
                int heartsLost = (int)xpHeartsLost + containersLost;
                if (heartsLost > 0) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("text.levelhearts.punish", new Object[]{heartsLost}));
                }
            } else {
                cap.setModifier(newModifier);
                cap.setRampPosition((short)(newModifier / 2.0f));
                player.func_145747_a((ITextComponent)new TranslationTextComponent("text.levelhearts.punish", new Object[]{amount / 2}));
            }
            MoreHealth.updateClient((ServerPlayerEntity)player, cap);
        }
        if (((Boolean)Config.loseXpOnDeath.get()).booleanValue()) {
            player.func_82242_a(-player.field_71068_ca - 1);
        }
        LevelHearts.recalcPlayerHealth(player, player.field_71068_ca);
        LevelHearts.applyHealthModifier(player, cap.getTrueModifier());
        player.func_70606_j(player.func_110138_aP());
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        if (event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        LevelHearts.debug("LivingDamage{Event}");
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (((Boolean)Config.enableOhko.get()).booleanValue()) {
            player.func_70606_j(0.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        LevelHearts.debug("LivingDeath{Event}");
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (((Boolean)Config.loseInvOnDeath.get()).booleanValue()) {
            try {
                ObfuscationReflectionHelper.findMethod(PlayerEntity.class, (String)"dropInventory", (Class[])new Class[0]).invoke((Object)player, new Object[0]);
                ObfuscationReflectionHelper.findMethod(PlayerEntity.class, (String)"destroyVanishingCursedItems", (Class[])new Class[0]).invoke((Object)player, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            player.field_71071_by.func_70436_m();
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getPlayer().func_130014_f_().field_72995_K) {
            return;
        }
        LevelHearts.debug("PlayerChangedDimension{Event}");
        PlayerEntity player = event.getPlayer();
        IMoreHealth cap = MoreHealth.getFromPlayer(player);
        LevelHearts.applyHealthModifier(player, cap.getTrueModifier());
        cap.synchronise(player);
    }

    @SubscribeEvent
    public static void onPlayerLevelUp(PlayerXpEvent.LevelChange event) {
        if (event.getPlayer().func_130014_f_().field_72995_K) {
            return;
        }
        LevelHearts.debug("PlayerLevelChange{Event}");
        PlayerEntity player = event.getPlayer();
        LevelHearts.recalcPlayerHealth(player, player.field_71068_ca + event.getLevels());
    }

    @SubscribeEvent
    public static void onPlayerPickupXp(PlayerXpEvent.PickupXp event) {
        LevelHearts.debug("PlayerPickupXp{Event}");
        event.getOrb().field_70530_e = (int)((double)event.getOrb().field_70530_e * (Double)Config.xpMultiplier.get());
    }

    @SubscribeEvent
    public static void onExperienceDrop(LivingExperienceDropEvent event) {
        if (((Boolean)Config.loseXpOnDeath.get()).booleanValue() && event.getEntity() instanceof PlayerEntity) {
            LevelHearts.debug("ExperienceDrop{Event}");
            PlayerEntity player = (PlayerEntity)event.getEntity();
            int i = player.field_71068_ca * 7;
            event.setDroppedExperience(Math.min(i, 100));
        }
    }

    @SubscribeEvent
    public static void onServerStarting(FMLServerStartingEvent event) {
        CommandDispatcher dispatcher = event.getCommandDispatcher();
        LevelHeartsCommand.register((CommandDispatcher<CommandSource>)dispatcher);
    }
}

