/*
 * Decompiled with CFR 0.152.
 */
package com.firecontroller1847.levelhearts;

import com.firecontroller1847.levelhearts.Config;
import com.firecontroller1847.levelhearts.PacketManager;
import com.firecontroller1847.levelhearts.capabilities.IMoreHealth;
import com.firecontroller1847.levelhearts.capabilities.MoreHealth;
import com.firecontroller1847.levelhearts.capabilities.MoreHealthStorage;
import com.firecontroller1847.levelhearts.gui.IngameGui;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="levelhearts")
@Mod.EventBusSubscriber(modid="levelhearts", bus=Mod.EventBusSubscriber.Bus.MOD)
public class LevelHearts {
    public static final String MOD_ID = "levelhearts";
    public static final String MOD_NAME = "LevelHearts";
    public static final String MOD_VERSION = "2.2.0";
    private static final UUID MODIFIER_ID = UUID.fromString("81f27f52-c8bb-403a-a1a4-b356d2f7a0f0");
    private static final Logger logger = LogManager.getLogger((String)"levelhearts");

    public LevelHearts() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.SPEC, "levelhearts.toml");
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(IMoreHealth.class, (Capability.IStorage)new MoreHealthStorage(), MoreHealth::new);
        PacketManager.register();
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new IngameGui());
    }

    public static void debug(String message) {
        if (((Boolean)Config.enableDebug.get()).booleanValue()) {
            logger.info(message);
        }
    }

    public static void debug(Object object) {
        LevelHearts.debug(object.toString());
    }

    public static void error(Exception exception) {
        logger.throwing((Throwable)exception);
    }

    public static void applyHealthModifier(PlayerEntity player, double amount) {
        LevelHearts.debug("LevelHearts#applyHealthModifier");
        AttributeModifier modifier = new AttributeModifier(MODIFIER_ID, "levelHearts.healthModifier", amount, AttributeModifier.Operation.ADDITION);
        ModifiableAttributeInstance attribute = player.func_110148_a(Attributes.field_233818_a_);
        attribute.func_111124_b(modifier);
        attribute.func_233769_c_(modifier);
    }

    public static void recalcPlayerHealth(PlayerEntity player, int level) {
        LevelHearts.debug("LevelHearts#calcPlayerHealth");
        IMoreHealth cap = MoreHealth.getFromPlayer(player);
        ArrayList ramp = (ArrayList)Config.levelRamp.get();
        int max = (Integer)Config.maxHealth.get() > 0 ? (Integer)Config.maxHealth.get() : 1024;
        boolean changed = false;
        if (cap.getRampPosition() < 0) {
            cap.setRampPosition((short)0);
        }
        while (cap.getRampPosition() < ramp.size() && level >= (Integer)ramp.get(cap.getRampPosition()) && player.func_110138_aP() < (float)max) {
            LevelHearts.debug("LevelHearts#calcPlayerHealth: Adding a heart to the player.");
            changed = true;
            cap.addRampPosition();
            cap.setModifier(cap.getModifier() + 2.0f);
            player.func_145747_a((ITextComponent)new TranslationTextComponent("text.levelhearts.heartadded"), Util.field_240973_b_);
            LevelHearts.applyHealthModifier(player, cap.getTrueModifier());
        }
        if (changed) {
            MoreHealth.updateClient((ServerPlayerEntity)player, cap);
            player.func_70606_j(player.func_110138_aP());
        }
    }
}

