/*
 * Decompiled with CFR 0.152.
 */
package com.firecontroller1847.levelhearts;

import com.firecontroller1847.levelhearts.Config;
import com.firecontroller1847.levelhearts.LevelHearts;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="levelhearts", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LevelHeartsLoot {
    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (!((Boolean)Config.enableLoot.get()).booleanValue()) {
            return;
        }
        String[] path = event.getName().func_110623_a().split("/");
        if (path[0].equals("chests")) {
            if (path[1].equals("village")) {
                if (path[2].contains("house") || path[2].equals("village_cartographer") || path[2].equals("village_fisher") || path[2].equals("village_fletcher") || path[2].equals("village_mason") || path[2].equals("village_shepherd") || path[2].equals("village_tannery") || path[2].equals("village_toolsmith")) {
                    return;
                }
                event.getTable().addPool(LevelHeartsLoot.fetchLootPool(String.format("%s/%s/lh_%s", path[0], path[1], path[2])));
            } else {
                if (path[1].equals("igloo_chest") || path[1].equals("nether_bridge") || path[1].equals("jungle_temple_dispenser") || path[1].equals("shipwreck_map") || path[1].equals("shipwreck_supply") || path[1].equals("spawn_bonus_chest") || path[1].equals("stronghold_crossing") || path[1].equals("stronghold_library")) {
                    return;
                }
                event.getTable().addPool(LevelHeartsLoot.fetchLootPool(String.format("%s/lh_%s", path[0], path[1])));
            }
        }
    }

    public static LootPool fetchLootPool(String location) {
        return LevelHeartsLoot.fetchLootPool("levelhearts:", location);
    }

    public static LootPool fetchLootPool(String namespace, String location) {
        LevelHearts.debug("LootTableLoad{Event}: Creating new loot pool @ " + namespace + location);
        StandaloneLootEntry.Builder entry = TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation(namespace + location)).func_216085_b(1);
        return LootPool.func_216096_a().func_216045_a((LootEntry.Builder)entry).name("levelhearts_inject").func_216044_b();
    }
}

