/*
 * Decompiled with CFR 0.152.
 */
package com.firecontroller1847.levelhearts.capabilities;

import com.firecontroller1847.levelhearts.Config;
import com.firecontroller1847.levelhearts.PacketManager;
import com.firecontroller1847.levelhearts.capabilities.IMoreHealth;
import com.firecontroller1847.levelhearts.capabilities.MoreHealthProvider;
import com.firecontroller1847.levelhearts.packets.SyncHealthPacket;
import java.util.Collections;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityPropertiesPacket;
import net.minecraft.world.server.ServerWorld;

public class MoreHealth
implements IMoreHealth {
    private byte version = 1;
    private float modifier = MoreHealth.getDefaultModifier();
    private short rampPosition = 0;
    private byte containers;

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public float getModifier() {
        return this.modifier;
    }

    @Override
    public float getTrueModifier() {
        return this.modifier + (float)(this.containers * 2);
    }

    @Override
    public short getRampPosition() {
        return this.rampPosition;
    }

    @Override
    public byte getHeartContainers() {
        return this.containers;
    }

    @Override
    public void setVersion(byte version) {
        this.version = version;
    }

    @Override
    public void setModifier(float modifier) {
        this.modifier = modifier;
    }

    @Override
    public void setRampPosition(short position) {
        this.rampPosition = position;
    }

    @Override
    public void addRampPosition() {
        this.rampPosition = (short)(this.rampPosition + 1);
    }

    @Override
    public void setHeartContainers(byte amount) {
        this.containers = amount;
    }

    @Override
    public void addHeartContainer() {
        this.containers = (byte)(this.containers + 1);
    }

    @Override
    public void copy(IMoreHealth other) {
        this.setVersion(other.getVersion());
        this.setModifier(other.getModifier());
        this.setRampPosition(other.getRampPosition());
        this.setHeartContainers(other.getHeartContainers());
    }

    @Override
    public void synchronise(PlayerEntity player) {
        if (!player.func_130014_f_().field_72995_K) {
            ModifiableAttributeInstance attribute = player.func_110148_a(Attributes.field_233818_a_);
            SEntityPropertiesPacket packet = new SEntityPropertiesPacket(player.func_145782_y(), Collections.singleton(attribute));
            ((ServerWorld)player.func_130014_f_()).func_72863_F().func_217216_a((Entity)player, (IPacket)packet);
        }
    }

    public static float getDefaultModifier() {
        return (float)((Integer)Config.defHealth.get()).intValue() - (float)Attributes.field_233818_a_.func_111110_b();
    }

    public static IMoreHealth getFromPlayer(PlayerEntity player) {
        return (IMoreHealth)player.getCapability(MoreHealthProvider.CAPABILITY, null).orElseThrow(() -> new IllegalArgumentException("LazyOptional must not be empty!"));
    }

    public static void updateClient(ServerPlayerEntity player, IMoreHealth cap) {
        PacketManager.sendTo(player, new SyncHealthPacket(player.func_145782_y(), (CompoundNBT)MoreHealthProvider.CAPABILITY.writeNBT((Object)cap, null)));
    }

    public String toString() {
        return String.format("MoreHealth{version=%s,modifier=%s,rampPosition=%s, containers=%s}", this.version, Float.valueOf(this.modifier), this.rampPosition, this.containers);
    }
}

