/*
 * Decompiled with CFR 0.152.
 */
package com.firecontroller1847.levelhearts.commands;

import com.firecontroller1847.levelhearts.LevelHearts;
import com.firecontroller1847.levelhearts.capabilities.IMoreHealth;
import com.firecontroller1847.levelhearts.capabilities.MoreHealth;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;

public class LevelHeartsCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralCommandNode command = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"levelhearts").requires(context -> context.func_197034_c(2))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"hearts").then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197096_c()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> LevelHeartsCommand.addHealth((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), true))).then(Commands.func_197056_a((String)"heal", (ArgumentType)BoolArgumentType.bool()).executes(context -> LevelHeartsCommand.addHealth((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), BoolArgumentType.getBool((CommandContext)context, (String)"heal")))))))).then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197096_c()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> LevelHeartsCommand.setHealth((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), true))).then(Commands.func_197056_a((String)"heal", (ArgumentType)BoolArgumentType.bool()).executes(context -> LevelHeartsCommand.setHealth((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), BoolArgumentType.getBool((CommandContext)context, (String)"heal"))))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"containers").then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197096_c()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)-127, (int)127)).executes(context -> LevelHeartsCommand.addContainers((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), true))).then(Commands.func_197056_a((String)"heal", (ArgumentType)BoolArgumentType.bool()).executes(context -> LevelHeartsCommand.addContainers((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), BoolArgumentType.getBool((CommandContext)context, (String)"heal")))))))).then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197096_c()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)127)).executes(context -> LevelHeartsCommand.setContainers((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), true))).then(Commands.func_197056_a((String)"heal", (ArgumentType)BoolArgumentType.bool()).executes(context -> LevelHeartsCommand.setContainers((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), BoolArgumentType.getBool((CommandContext)context, (String)"heal")))))))));
    }

    private static int addHealth(CommandSource source, ServerPlayerEntity targetPlayer, int amount, boolean heal) {
        LevelHearts.debug("LevelHeartsCommand#addHealth: Adding " + amount * 2 + " health!");
        IMoreHealth cap = MoreHealth.getFromPlayer((PlayerEntity)targetPlayer);
        float newModifier = cap.getModifier() + (float)(amount * 2);
        if (newModifier <= -((float)Attributes.field_233818_a_.func_111110_b())) {
            newModifier = amount > 0 ? 1024.0f : -((float)Attributes.field_233818_a_.func_111110_b()) + 2.0f;
        }
        cap.setModifier(newModifier);
        cap.setRampPosition((short)0);
        MoreHealth.updateClient(targetPlayer, cap);
        LevelHearts.applyHealthModifier((PlayerEntity)targetPlayer, cap.getTrueModifier());
        if (heal) {
            targetPlayer.func_70606_j(targetPlayer.func_110138_aP());
        } else {
            targetPlayer.func_70606_j(targetPlayer.func_110143_aJ() - 1.0f);
            targetPlayer.func_70606_j(targetPlayer.func_110143_aJ() + 1.0f);
        }
        return 1;
    }

    private static int setHealth(CommandSource source, ServerPlayerEntity targetPlayer, int amount, boolean heal) {
        LevelHearts.debug("LevelHeartsCommand#addHealth: Setting health to " + amount * 2 + "!");
        IMoreHealth cap = MoreHealth.getFromPlayer((PlayerEntity)targetPlayer);
        cap.setModifier((float)(amount * 2) - (float)Attributes.field_233818_a_.func_111110_b());
        cap.setRampPosition((short)0);
        MoreHealth.updateClient(targetPlayer, cap);
        LevelHearts.applyHealthModifier((PlayerEntity)targetPlayer, cap.getTrueModifier());
        if (heal) {
            targetPlayer.func_70606_j(targetPlayer.func_110138_aP());
        } else {
            targetPlayer.func_70606_j(targetPlayer.func_110143_aJ() - 1.0f);
            targetPlayer.func_70606_j(targetPlayer.func_110143_aJ() + 1.0f);
        }
        return 1;
    }

    private static int addContainers(CommandSource source, ServerPlayerEntity targetPlayer, int amount, boolean heal) {
        LevelHearts.debug("LevelHeartsCommand#addHealth: Adding " + amount + " heart containers!");
        IMoreHealth cap = MoreHealth.getFromPlayer((PlayerEntity)targetPlayer);
        int newContainers = cap.getHeartContainers() + amount;
        if (newContainers < 0) {
            newContainers = amount > 0 ? 127 : 0;
        }
        cap.setHeartContainers((byte)newContainers);
        MoreHealth.updateClient(targetPlayer, cap);
        LevelHearts.applyHealthModifier((PlayerEntity)targetPlayer, cap.getTrueModifier());
        if (heal) {
            targetPlayer.func_70606_j(targetPlayer.func_110138_aP());
        } else {
            targetPlayer.func_70606_j(targetPlayer.func_110143_aJ() - 1.0f);
            targetPlayer.func_70606_j(targetPlayer.func_110143_aJ() + 1.0f);
        }
        return 1;
    }

    private static int setContainers(CommandSource source, ServerPlayerEntity targetPlayer, int amount, boolean heal) {
        LevelHearts.debug("LevelHeartsCommand#addHealth: Setting heart containers to " + amount + "!");
        IMoreHealth cap = MoreHealth.getFromPlayer((PlayerEntity)targetPlayer);
        cap.setHeartContainers((byte)amount);
        MoreHealth.updateClient(targetPlayer, cap);
        LevelHearts.applyHealthModifier((PlayerEntity)targetPlayer, cap.getTrueModifier());
        if (heal) {
            targetPlayer.func_70606_j(targetPlayer.func_110138_aP());
        } else {
            targetPlayer.func_70606_j(targetPlayer.func_110143_aJ() - 1.0f);
            targetPlayer.func_70606_j(targetPlayer.func_110143_aJ() + 1.0f);
        }
        return 1;
    }
}

