/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiConsumer;
import melonslise.locks.client.gui.sprite.SpringSprite;
import melonslise.locks.client.gui.sprite.Sprite;
import melonslise.locks.client.gui.sprite.TextureInfo;
import melonslise.locks.client.gui.sprite.action.AccelerateAction;
import melonslise.locks.client.gui.sprite.action.FadeAction;
import melonslise.locks.client.gui.sprite.action.IAction;
import melonslise.locks.client.gui.sprite.action.MoveAction;
import melonslise.locks.client.gui.sprite.action.WaitAction;
import melonslise.locks.common.container.LockPickingContainer;
import melonslise.locks.common.init.LocksNetwork;
import melonslise.locks.common.network.toserver.TryPinPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LockPickingScreen
extends ContainerScreen<LockPickingContainer> {
    public static final ITextComponent HINT = new TranslationTextComponent("locks.gui.lockpicking.open");
    public static final TextureInfo FRONT_WALL_TEX = new TextureInfo(6, 0, 4, 60, 48, 80);
    public static final TextureInfo COLUMN_TEX = new TextureInfo(10, 0, 8, 60, 48, 80);
    public static final TextureInfo INNER_WALL_TEX = new TextureInfo(18, 0, 4, 60, 48, 80);
    public static final TextureInfo BACK_WALL_TEX = new TextureInfo(22, 0, 4, 60, 48, 80);
    public static final TextureInfo HANDLE_TEX = new TextureInfo(26, 0, 19, 73, 48, 80);
    public static final TextureInfo UPPER_PIN_TEX = new TextureInfo(0, 0, 6, 8, 48, 80);
    public static final TextureInfo LOCK_PICK_TEX = new TextureInfo(0, 0, 160, 12, 160, 16);
    public static final TextureInfo[] PIN_TUMBLER_TEX = new TextureInfo[]{new TextureInfo(0, 8, 6, 11, 48, 80), new TextureInfo(0, 19, 6, 13, 48, 80), new TextureInfo(0, 32, 6, 15, 48, 80)};
    public static final TextureInfo[] SPRING_TEX = new TextureInfo[]{new TextureInfo(0, 57, 6, 23, 48, 80), new TextureInfo(6, 60, 6, 20, 48, 80), new TextureInfo(12, 64, 6, 16, 48, 80), new TextureInfo(18, 69, 6, 11, 48, 80), new TextureInfo(24, 73, 6, 7, 48, 80)};
    public final ResourceLocation lockTex;
    protected ResourceLocation pickTex;
    protected Collection<Sprite> sprites;
    protected Sprite lockPick;
    protected Sprite leftPickPart;
    protected Sprite rightPickPart;
    protected Sprite[] pinTumblers;
    protected Sprite[] upperPins;
    protected Sprite[] springs;
    public final BiConsumer<IAction<Sprite>, Sprite> unfreezeCb = (action, sprite) -> {
        this.frozen = false;
    };
    public final BiConsumer<IAction<Sprite>, Sprite> resetPickCb = (action, sprite) -> this.resetPick();
    public final int length;
    public final boolean[] pins;
    public final Hand hand;
    protected int currPin;
    protected boolean frozen = true;

    public LockPickingScreen(LockPickingContainer cont, PlayerInventory inv, ITextComponent title) {
        super((Container)cont, inv, title);
        this.length = cont.lockable.lock.getLength();
        this.pins = new boolean[this.length];
        this.hand = cont.hand;
        this.lockTex = LockPickingScreen.getTextureFor(cont.lockable.stack);
        this.field_146999_f = (LockPickingScreen.FRONT_WALL_TEX.width + this.length * (LockPickingScreen.COLUMN_TEX.width + LockPickingScreen.INNER_WALL_TEX.width)) * 2;
        this.field_147000_g = LockPickingScreen.HANDLE_TEX.height * 2;
        this.sprites = new ArrayDeque<Sprite>(this.length * 3 + 4);
        this.pinTumblers = new Sprite[this.length];
        this.upperPins = new Sprite[this.length];
        this.springs = new Sprite[this.length];
        for (int a = 0; a < this.pinTumblers.length; ++a) {
            int r = ThreadLocalRandom.current().nextInt(3);
            this.pinTumblers[a] = this.addSprite(new Sprite(PIN_TUMBLER_TEX[r]).position(LockPickingScreen.FRONT_WALL_TEX.width + 1 + a * (LockPickingScreen.COLUMN_TEX.width + LockPickingScreen.INNER_WALL_TEX.width), 43 - LockPickingScreen.PIN_TUMBLER_TEX[r].height));
            this.upperPins[a] = new Sprite(UPPER_PIN_TEX).position(LockPickingScreen.FRONT_WALL_TEX.width + 1 + a * (LockPickingScreen.COLUMN_TEX.width + LockPickingScreen.INNER_WALL_TEX.width), 43 - LockPickingScreen.PIN_TUMBLER_TEX[r].height - LockPickingScreen.UPPER_PIN_TEX.height);
            this.springs[a] = this.addSprite(new SpringSprite(SPRING_TEX, this.upperPins[a]).position(LockPickingScreen.FRONT_WALL_TEX.width + 1 + a * (LockPickingScreen.COLUMN_TEX.width + LockPickingScreen.INNER_WALL_TEX.width), 3.0f));
            this.addSprite(this.upperPins[a]);
        }
        this.lockPick = this.addSprite(new Sprite(LOCK_PICK_TEX).position(0.0f, -4 + LockPickingScreen.COLUMN_TEX.height - LockPickingScreen.LOCK_PICK_TEX.height));
        this.resetPick();
        this.rightPickPart = this.addSprite(new Sprite(new TextureInfo(0, 0, 0, 12, 160, 16)).position(-10.0f, this.lockPick.posY).alpha(0.0f));
        this.leftPickPart = this.addSprite(new Sprite(new TextureInfo(0, 0, 0, 12, 160, 16)).position(0.0f, this.lockPick.posY).rotation(-30.0f, -10.0f, this.lockPick.posY + 13.0f).alpha(0.0f));
    }

    public static ResourceLocation getTextureFor(ItemStack stack) {
        return new ResourceLocation("locks", "textures/gui/" + stack.func_77973_b().getRegistryName().func_110623_a() + ".png");
    }

    public Sprite addSprite(Sprite sprite) {
        this.sprites.add(sprite);
        return sprite;
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_230430_a_(MatrixStack mtx, int mouseX, int mouseY, float partialTick) {
        this.func_230446_a_(mtx);
        super.func_230430_a_(mtx, mouseX, mouseY, partialTick);
    }

    protected void func_230450_a_(MatrixStack mtx, float partialTick, int mouseX, int mouseY) {
        float pt = this.field_230706_i_.func_184121_ak();
        int cornerX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int cornerY = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.field_230706_i_.func_110434_K().func_110577_a(this.lockTex);
        mtx.func_227860_a_();
        mtx.func_227861_a_((double)cornerX, (double)cornerY, 0.0);
        mtx.func_227862_a_(2.0f, 2.0f, 2.0f);
        FRONT_WALL_TEX.draw(mtx, 0.0f, 0.0f, 1.0f);
        for (int a = 0; a < this.length; ++a) {
            COLUMN_TEX.draw(mtx, LockPickingScreen.FRONT_WALL_TEX.width + a * (LockPickingScreen.COLUMN_TEX.width + LockPickingScreen.INNER_WALL_TEX.width), 0.0f, 1.0f);
            if (a == this.length - 1) continue;
            INNER_WALL_TEX.draw(mtx, LockPickingScreen.FRONT_WALL_TEX.width + LockPickingScreen.COLUMN_TEX.width + a * (LockPickingScreen.COLUMN_TEX.width + LockPickingScreen.INNER_WALL_TEX.width), 0.0f, 1.0f);
        }
        BACK_WALL_TEX.draw(mtx, this.length * (LockPickingScreen.COLUMN_TEX.width + LockPickingScreen.INNER_WALL_TEX.width), 0.0f, 1.0f);
        HANDLE_TEX.draw(mtx, LockPickingScreen.BACK_WALL_TEX.width + this.length * (LockPickingScreen.COLUMN_TEX.width + LockPickingScreen.INNER_WALL_TEX.width), 2.0f, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        for (Sprite sprite : this.sprites) {
            if (sprite == this.lockPick) {
                this.field_230706_i_.func_110434_K().func_110577_a(this.pickTex);
            }
            sprite.draw(mtx, pt);
        }
        mtx.func_227865_b_();
    }

    protected void func_230451_b_(MatrixStack mtx, int mouseX, int mouseY) {
        this.field_230712_o_.getClass();
        this.field_230712_o_.func_243248_b(mtx, this.field_230704_d_, 0.0f, (float)(-9), 0xFFFFFF);
        if (((LockPickingContainer)this.func_212873_a_()).isOpen()) {
            this.field_230712_o_.func_243248_b(mtx, HINT, (float)(this.field_146999_f - this.field_230712_o_.func_238414_a_((ITextProperties)HINT)) / 2.0f, (float)this.field_147000_g + 10.0f, 0xFFFFFF);
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        for (Sprite sprite : this.sprites) {
            sprite.update();
        }
        if (!this.frozen) {
            this.boundLockPick();
        }
        this.updatePickParts();
    }

    protected void updatePickParts() {
        this.rightPickPart.posY = this.lockPick.posY;
        this.rightPickPart.tex.width = 10 + (int)this.lockPick.posX + this.lockPick.tex.width;
        this.rightPickPart.tex.startX = this.rightPickPart.tex.canvasWidth - this.rightPickPart.tex.width;
        this.leftPickPart.posY = this.lockPick.posY;
        this.leftPickPart.tex.width = this.rightPickPart.tex.startX;
        this.leftPickPart.posX = -10 - this.leftPickPart.tex.width;
    }

    protected void boundLockPick() {
        this.lockPick.posX = (float)(10 - LockPickingScreen.LOCK_PICK_TEX.width) + MathHelper.func_76131_a((float)(this.lockPick.posX - 10.0f + (float)LockPickingScreen.LOCK_PICK_TEX.width), (float)0.0f, (float)((this.length - 1) * (LockPickingScreen.COLUMN_TEX.width + LockPickingScreen.INNER_WALL_TEX.width)));
    }

    public boolean func_231046_a_(int key, int scan, int modifier) {
        if (this.frozen) {
            return super.func_231046_a_(key, scan, modifier);
        }
        if (key == this.field_230706_i_.field_71474_y.field_74370_x.getKey().func_197937_c()) {
            this.lockPick.speedX = -4.0f;
        } else if (key == this.field_230706_i_.field_71474_y.field_74366_z.getKey().func_197937_c()) {
            this.lockPick.speedX = 4.0f;
        } else if (key == this.field_230706_i_.field_71474_y.field_74351_w.getKey().func_197937_c() && !this.lockPick.isExecuting() && this.pullPin(this.getSelectedPin())) {
            this.lockPick.execute(MoveAction.at(0.0f, -2.5f).time(3), MoveAction.at(0.0f, 2.5f).time(3));
        }
        return super.func_231046_a_(key, scan, modifier);
    }

    public boolean func_223281_a_(int key, int scan, int modifier) {
        if (this.frozen) {
            return super.func_223281_a_(key, scan, modifier);
        }
        if (key == this.field_230706_i_.field_71474_y.field_74370_x.getKey().func_197937_c() || key == this.field_230706_i_.field_71474_y.field_74366_z.getKey().func_197937_c()) {
            this.lockPick.speedX = 0.0f;
        }
        return super.func_223281_a_(key, scan, modifier);
    }

    protected int getSelectedPin() {
        return (int)((this.lockPick.posX - 10.0f + (float)LockPickingScreen.LOCK_PICK_TEX.width) / (float)(LockPickingScreen.COLUMN_TEX.width + LockPickingScreen.INNER_WALL_TEX.width) + 0.5f);
    }

    protected boolean pullPin(int pin) {
        if (this.pins[pin]) {
            return false;
        }
        this.currPin = pin;
        LocksNetwork.MAIN.sendToServer((Object)new TryPinPacket((byte)pin));
        return true;
    }

    public void handlePin(boolean correct, boolean reset) {
        this.pinTumblers[this.currPin].execute(MoveAction.at(0.0f, -6.0f).time(2), MoveAction.at(0.0f, 6.0f).time(2));
        this.upperPins[this.currPin].execute(MoveAction.at(0.0f, -6.0f).time(2));
        if (correct) {
            this.pins[this.currPin] = true;
            this.upperPins[this.currPin].execute(MoveAction.to(this.upperPins[this.currPin], this.upperPins[this.currPin].posX, 29.0f, 2));
        } else {
            this.upperPins[this.currPin].execute(MoveAction.at(0.0f, 6.0f).time(2));
        }
        if (reset) {
            this.reset();
        }
    }

    public void reset() {
        for (int a = 0; a < this.pins.length; ++a) {
            if (!this.pins[a]) continue;
            this.pins[a] = false;
            this.upperPins[a].execute(MoveAction.to(this.upperPins[a], this.upperPins[a].posX, this.pinTumblers[a].posY - (float)LockPickingScreen.UPPER_PIN_TEX.height, 2));
        }
        this.lockPick.alpha(0.0f);
        this.rightPickPart.alpha(1.0f).execute(WaitAction.ticks(10), FadeAction.to(this.rightPickPart, 0.0f, 4));
        this.leftPickPart.alpha(1.0f).execute(WaitAction.ticks(10), FadeAction.to(this.rightPickPart, 0.0f, 4).then(this.resetPickCb));
        this.frozen = true;
    }

    public void resetPick() {
        this.pickTex = LockPickingScreen.getTextureFor(Minecraft.func_71410_x().field_71439_g.func_184586_b(this.hand));
        this.lockPick.position(-22 - LockPickingScreen.LOCK_PICK_TEX.width, this.lockPick.posY).alpha(1.0f).execute(AccelerateAction.to(32.0f, 0.0f, 4, false).then(this.unfreezeCb));
    }
}

