/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.client.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class LocksClientUtil {
    private LocksClientUtil() {
    }

    public static ActiveRenderInfo getCamera() {
        return Minecraft.func_71410_x().field_71460_t.func_215316_n();
    }

    public static ClippingHelper getClippingHelper(MatrixStack mtx, Matrix4f proj) {
        ClippingHelper ch = Minecraft.func_71410_x().field_71438_f.field_175001_U;
        if (ch != null) {
            return ch;
        }
        ch = new ClippingHelper(mtx.func_227866_c_().func_227870_a_(), proj);
        Vector3d pos = LocksClientUtil.getCamera().func_216785_c();
        ch.func_228952_a_(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        return ch;
    }

    public static double distanceToLineSq(Vector3d p, Vector3d l1, Vector3d l2) {
        Vector3d l = l2.func_178788_d(l1);
        return l.func_72431_c(p.func_178788_d(l1)).func_189985_c() / l.func_189985_c();
    }

    public static Vector3f worldToScreen(Vector3d pos, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        ActiveRenderInfo cam = LocksClientUtil.getCamera();
        Vector3d o = cam.func_216785_c();
        Vector3f pos1 = new Vector3f((float)(o.field_72450_a - pos.field_72450_a), (float)(o.field_72448_b - pos.field_72448_b), (float)(o.field_72449_c - pos.field_72449_c));
        Quaternion rot = cam.func_227995_f_().func_227068_g_();
        rot.func_195892_e();
        pos1.func_214905_a(rot);
        if (mc.field_71474_y.field_74336_f && mc.func_175606_aa() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)mc.func_175606_aa();
            float f = player.field_70140_Q - player.field_70141_P;
            float f1 = -(player.field_70140_Q + f * partialTicks);
            float f2 = MathHelper.func_219799_g((float)partialTicks, (float)player.field_71107_bF, (float)player.field_71109_bG);
            Quaternion rot1 = Vector3f.field_229179_b_.func_229187_a_(Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI - 0.2f)) * f2) * 5.0f);
            Quaternion rot2 = Vector3f.field_229183_f_.func_229187_a_(MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f2 * 3.0f);
            rot1.func_195892_e();
            rot2.func_195892_e();
            pos1.func_214905_a(rot1);
            pos1.func_214905_a(rot2);
            pos1.func_195904_b(MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f2 * 0.5f, Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI)) * f2), 0.0f);
        }
        MainWindow w = mc.func_228018_at_();
        float sc = (float)w.func_198087_p() / 2.0f / pos1.func_195902_c() / (float)Math.tan(Math.toRadians(mc.field_71460_t.func_215311_a(cam, partialTicks, true) / 2.0));
        pos1.func_229192_b_(-sc, -sc, 1.0f);
        pos1.func_195904_b((float)w.func_198107_o() / 2.0f, (float)w.func_198087_p() / 2.0f, 0.0f);
        return pos1;
    }

    public static void texture(MatrixStack mtx, float x, float y, int u, int v, int width, int height, int texWidth, int texHeight, float alpha) {
        Matrix4f last = mtx.func_227866_c_().func_227870_a_();
        float f = 1.0f / (float)texWidth;
        float f1 = 1.0f / (float)texHeight;
        BufferBuilder buf = Tessellator.func_178181_a().func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buf.func_227888_a_(last, x, y + (float)height, 0.0f).func_225583_a_((float)u * f, (float)(v + height) * f1).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        buf.func_227888_a_(last, x + (float)width, y + (float)height, 0.0f).func_225583_a_((float)(u + width) * f, (float)(v + height) * f1).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        buf.func_227888_a_(last, x + (float)width, y, 0.0f).func_225583_a_((float)(u + width) * f, (float)v * f1).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        buf.func_227888_a_(last, x, y, 0.0f).func_225583_a_((float)u * f, (float)v * f1).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        buf.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)buf);
    }

    public static void line(BufferBuilder buf, MatrixStack mtx, float x1, float y1, float x2, float y2, float width, float r, float g, float b, float a) {
        Matrix4f last = mtx.func_227866_c_().func_227870_a_();
        float pX = y2 - y1;
        float pY = x1 - x2;
        float pL = MathHelper.func_76129_c((float)(pX * pX + pY * pY));
        buf.func_227888_a_(last, x1 + (pX *= width / 2.0f / pL), y1 + (pY *= width / 2.0f / pL), 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buf.func_227888_a_(last, x1 - pX, y1 - pY, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buf.func_227888_a_(last, x2 - pX, y2 - pY, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buf.func_227888_a_(last, x2 + pX, y2 + pY, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void square(BufferBuilder buf, MatrixStack mtx, float x, float y, float length, float r, float g, float b, float a) {
        Matrix4f last = mtx.func_227866_c_().func_227870_a_();
        buf.func_227888_a_(last, x - (length /= 2.0f), y - length, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buf.func_227888_a_(last, x - length, y + length, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buf.func_227888_a_(last, x + length, y + length, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buf.func_227888_a_(last, x + length, y - length, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void vGradient(BufferBuilder bld, MatrixStack mtx, int x1, int y1, int x2, int y2, float r1, float g1, float b1, float a1, float r2, float g2, float b2, float a2) {
        Matrix4f last = mtx.func_227866_c_().func_227870_a_();
        bld.func_227888_a_(last, (float)x2, (float)y1, 0.0f).func_227885_a_(r1, g1, b1, a1).func_181675_d();
        bld.func_227888_a_(last, (float)x1, (float)y1, 0.0f).func_227885_a_(r1, g1, b1, a1).func_181675_d();
        bld.func_227888_a_(last, (float)x1, (float)y2, 0.0f).func_227885_a_(r2, g2, b2, a2).func_181675_d();
        bld.func_227888_a_(last, (float)x2, (float)y2, 0.0f).func_227885_a_(r2, g2, b2, a2).func_181675_d();
    }

    public static float lerp(float start, float end, float progress) {
        return start + (end - start) * progress;
    }

    public static double lerp(double start, double end, double progress) {
        return start + (end - start) * progress;
    }

    public static float cubicBezier1d(float anchor1, float anchor2, float progress) {
        float omp = 1.0f - progress;
        return 3.0f * omp * omp * progress * anchor1 + 3.0f * omp * progress * progress * anchor2 + progress * progress * progress;
    }
}

