/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.capability;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.concurrent.atomic.AtomicInteger;
import melonslise.locks.common.capability.ILockableHandler;
import melonslise.locks.common.capability.ILockableStorage;
import melonslise.locks.common.capability.LockableStorage;
import melonslise.locks.common.config.LocksServerConfig;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.init.LocksNetwork;
import melonslise.locks.common.init.LocksPacketDistributors;
import melonslise.locks.common.network.toclient.AddLockablePacket;
import melonslise.locks.common.network.toclient.RemoveLockablePacket;
import melonslise.locks.common.network.toclient.UpdateLockablePacket;
import melonslise.locks.common.util.Lockable;
import net.minecraft.nbt.IntNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class LockableHandler
implements ILockableHandler {
    public static final ResourceLocation ID = new ResourceLocation("locks", "lockable_handler");
    public final World world;
    public AtomicInteger lastId = new AtomicInteger();
    public Int2ObjectMap<Lockable> lockables = new Int2ObjectLinkedOpenHashMap();

    public LockableHandler(World world) {
        this.world = world;
    }

    @Override
    public int nextId() {
        return this.lastId.incrementAndGet();
    }

    @Override
    public Int2ObjectMap<Lockable> getLoaded() {
        return this.lockables;
    }

    @Override
    public Int2ObjectMap<Lockable> getInChunk(BlockPos pos) {
        return this.world.func_175667_e(pos) ? ((ILockableStorage)this.world.func_175726_f(pos).getCapability(LocksCapabilities.LOCKABLE_STORAGE).orElse(null)).get() : null;
    }

    @Override
    public boolean add(Lockable lkb) {
        if (lkb.bb.volume() > (Integer)LocksServerConfig.MAX_LOCKABLE_VOLUME.get()) {
            return false;
        }
        List<ILockableStorage> sts = lkb.bb.containedChunksTo((x, z) -> {
            if (!this.world.func_217354_b(x, z)) {
                return null;
            }
            ILockableStorage st = (ILockableStorage)this.world.func_212866_a_(x, z).getCapability(LocksCapabilities.LOCKABLE_STORAGE).orElse(null);
            return st.get().values().stream().anyMatch(lkb1 -> lkb1.bb.intersects(lkb.bb)) ? null : st;
        }, true);
        if (sts == null) {
            return false;
        }
        for (int a = 0; a < sts.size(); ++a) {
            sts.get(a).add(lkb);
        }
        this.lockables.put(lkb.id, (Object)lkb);
        lkb.addObserver(this);
        if (this.world.field_72995_K) {
            lkb.swing(10);
        } else {
            LocksNetwork.MAIN.send(LocksPacketDistributors.TRACKING_AREA.with(() -> sts.stream().map(st -> ((LockableStorage)st).chunk)), (Object)new AddLockablePacket(lkb));
        }
        return true;
    }

    @Override
    public boolean remove(int id) {
        Lockable lkb = (Lockable)this.lockables.get(id);
        if (lkb == this.lockables.defaultReturnValue()) {
            return false;
        }
        List<Chunk> chs = lkb.bb.containedChunksTo((x, z) -> this.world.func_217354_b(x, z) ? this.world.func_212866_a_(x, z) : null, true);
        for (int a = 0; a < chs.size(); ++a) {
            ((ILockableStorage)chs.get(a).getCapability(LocksCapabilities.LOCKABLE_STORAGE).orElse(null)).remove(id);
        }
        this.lockables.remove(id);
        lkb.deleteObserver(this);
        if (this.world.field_72995_K) {
            return true;
        }
        LocksNetwork.MAIN.send(LocksPacketDistributors.TRACKING_AREA.with(() -> chs.stream()), (Object)new RemoveLockablePacket(id));
        return true;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.world.field_72995_K || !(o instanceof Lockable)) {
            return;
        }
        Lockable lockable = (Lockable)o;
        LocksNetwork.MAIN.send(LocksPacketDistributors.TRACKING_AREA.with(() -> lockable.bb.containedChunksTo((x, z) -> this.world.func_217354_b(x, z) ? this.world.func_212866_a_(x, z) : null, false).stream().filter(Objects::nonNull)), (Object)new UpdateLockablePacket(lockable));
    }

    public IntNBT serializeNBT() {
        return IntNBT.func_229692_a_((int)this.lastId.get());
    }

    public void deserializeNBT(IntNBT nbt) {
        this.lastId.set(nbt.func_150287_d());
    }
}

