/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.container;

import java.util.function.Consumer;
import melonslise.locks.client.gui.LockPickingScreen;
import melonslise.locks.common.capability.ILockableHandler;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.init.LocksContainerTypes;
import melonslise.locks.common.init.LocksDamageSources;
import melonslise.locks.common.init.LocksEnchantments;
import melonslise.locks.common.init.LocksItemTags;
import melonslise.locks.common.init.LocksNetwork;
import melonslise.locks.common.init.LocksSoundEvents;
import melonslise.locks.common.item.LockPickItem;
import melonslise.locks.common.network.toclient.TryPinResultPacket;
import melonslise.locks.common.util.Lockable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.fml.network.PacketDistributor;

public class LockPickingContainer
extends Container {
    public static final ITextComponent TITLE = new TranslationTextComponent("locks.gui.lockpicking.title");
    public final PlayerEntity player;
    public final Hand hand;
    public final Lockable lockable;
    public final Vector3d pos;
    public final int shocking;
    public final int sturdy;
    public final int complexity;
    protected int currIndex = 0;
    public static final IContainerFactory<LockPickingContainer> FACTORY = (id, inv, buf) -> new LockPickingContainer(id, inv.field_70458_d, (Hand)buf.func_179257_a(Hand.class), (Lockable)((ILockableHandler)inv.field_70458_d.field_70170_p.getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null)).getLoaded().get(buf.readInt()));

    public LockPickingContainer(int id, PlayerEntity player, Hand hand, Lockable lkb) {
        super((ContainerType)LocksContainerTypes.LOCK_PICKING.get(), id);
        this.player = player;
        this.hand = hand;
        this.lockable = lkb;
        Lockable.State state = lkb.getLockState(player.field_70170_p);
        this.pos = state == null ? lkb.bb.center() : state.pos;
        this.shocking = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)LocksEnchantments.SHOCKING.get()), (ItemStack)this.lockable.stack);
        this.sturdy = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)LocksEnchantments.STURDY.get()), (ItemStack)this.lockable.stack);
        this.complexity = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)LocksEnchantments.COMPLEXITY.get()), (ItemStack)this.lockable.stack);
        for (int rows = 0; rows < 3; ++rows) {
            for (int cols = 0; cols < 9; ++cols) {
                this.func_75146_a(new HiddenSlot((IInventory)player.field_71071_by, cols + rows * 9 + 9, 0, 0));
            }
        }
        for (int slots = 0; slots < 9; ++slots) {
            this.func_75146_a(new HiddenSlot((IInventory)player.field_71071_by, slots, 0, 0));
        }
    }

    public boolean isValidPick(ItemStack stack) {
        return stack.func_77973_b().func_206844_a(LocksItemTags.LOCK_PICKS) && LockPickItem.canPick(stack, this.complexity);
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.lockable.lock.isLocked() && this.isValidPick(player.func_184586_b(this.hand));
    }

    public boolean isOpen() {
        return this.currIndex == this.lockable.lock.getLength();
    }

    protected void reset() {
        this.currIndex = 0;
    }

    public void tryPin(int currPin) {
        if (this.isOpen()) {
            return;
        }
        boolean correct = false;
        boolean reset = false;
        if (this.lockable.lock.checkPin(this.currIndex, currPin)) {
            ++this.currIndex;
            correct = true;
            this.player.field_70170_p.func_184148_a(null, this.pos.field_72450_a, this.pos.field_72448_b, this.pos.field_72449_c, (SoundEvent)LocksSoundEvents.PIN_MATCH.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else if (this.tryBreakPick(this.player, currPin)) {
            reset = true;
            this.reset();
            if (this.shocking > 0) {
                this.player.func_70097_a(LocksDamageSources.SHOCK, (float)this.shocking * 1.5f);
                this.player.field_70170_p.func_184148_a(null, this.player.func_213303_ch().field_72450_a, this.player.func_213303_ch().field_72448_b, this.player.func_213303_ch().field_72449_c, (SoundEvent)LocksSoundEvents.SHOCK.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        } else {
            this.player.field_70170_p.func_184148_a(null, this.pos.field_72450_a, this.pos.field_72448_b, this.pos.field_72449_c, (SoundEvent)LocksSoundEvents.PIN_FAIL.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        LocksNetwork.MAIN.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)this.player), (Object)new TryPinResultPacket(correct, reset));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handlePin(boolean correct, boolean reset) {
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof LockPickingScreen) {
            ((LockPickingScreen)screen).handlePin(correct, reset);
        }
        if (correct) {
            ++this.currIndex;
        }
        if (reset) {
            this.reset();
        }
    }

    protected boolean tryBreakPick(PlayerEntity player, int pin) {
        ItemStack pickStack = player.func_184586_b(this.hand);
        float sturdyModifier = this.sturdy == 0 ? 1.0f : 0.75f + (float)this.sturdy * 0.5f;
        float ch = LockPickItem.getOrSetStrength(pickStack) / sturdyModifier;
        float ex = (1.0f - ch) * (1.0f - this.getBreakChanceMultiplier(pin));
        if (!pickStack.func_77973_b().func_206844_a(LocksItemTags.LOCK_PICKS) || player.field_70170_p.field_73012_v.nextFloat() < ex + ch) {
            return false;
        }
        this.player.func_213334_d(this.hand);
        pickStack.func_190918_g(1);
        if (pickStack.func_190926_b()) {
            for (int a = 0; a < player.field_71071_by.func_70302_i_(); ++a) {
                ItemStack stack = player.field_71071_by.func_70301_a(a);
                if (!this.isValidPick(stack)) continue;
                player.func_184611_a(this.hand, stack);
                player.field_71071_by.func_70304_b(a);
                break;
            }
        }
        return true;
    }

    protected float getBreakChanceMultiplier(int pin) {
        return Math.abs(this.lockable.lock.getPin(this.currIndex) - pin) == 1 ? 0.33f : 1.0f;
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        if (!this.isOpen() || !this.lockable.lock.isLocked()) {
            return;
        }
        this.lockable.lock.setLocked(!this.lockable.lock.isLocked());
        this.player.field_70170_p.func_184148_a(player, this.pos.field_72450_a, this.pos.field_72448_b, this.pos.field_72449_c, (SoundEvent)LocksSoundEvents.LOCK_OPEN.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public static class Provider
    implements INamedContainerProvider {
        public final Hand hand;
        public final Lockable lockable;

        public Provider(Hand hand, Lockable lkb) {
            this.hand = hand;
            this.lockable = lkb;
        }

        public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
            return new LockPickingContainer(id, player, this.hand, this.lockable);
        }

        public ITextComponent func_145748_c_() {
            return TITLE;
        }
    }

    public static class Writer
    implements Consumer<PacketBuffer> {
        public final Hand hand;
        public final Lockable lockable;

        public Writer(Hand hand, Lockable lkb) {
            this.hand = hand;
            this.lockable = lkb;
        }

        @Override
        public void accept(PacketBuffer buf) {
            buf.func_179249_a((Enum)this.hand);
            buf.writeInt(this.lockable.id);
        }
    }

    public static class HiddenSlot
    extends Slot {
        public HiddenSlot(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean func_111238_b() {
            return false;
        }
    }
}

