/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.item;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import melonslise.locks.common.capability.CapabilityProvider;
import melonslise.locks.common.capability.KeyRingInventory;
import melonslise.locks.common.container.KeyRingContainer;
import melonslise.locks.common.init.LocksSoundEvents;
import melonslise.locks.common.item.LockingItem;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.LocksUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class KeyRingItem
extends Item {
    public final int rows;

    public KeyRingItem(int rows, Item.Properties props) {
        super(props.func_200917_a(1));
        this.rows = rows;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new CapabilityProvider<KeyRingInventory>(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, new KeyRingInventory(stack, this.rows, 9));
    }

    public static boolean containsId(ItemStack stack, int id) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        for (int a = 0; a < inv.getSlots(); ++a) {
            if (LockingItem.getOrSetId(inv.getStackInSlot(a)) != id) continue;
            return true;
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.field_70170_p.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new KeyRingContainer.Provider(stack), (Consumer)new KeyRingContainer.Writer(hand));
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        IItemHandler inv = (IItemHandler)ctx.func_195996_i().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        List intersect = LocksUtil.intersecting(world, pos).collect(Collectors.toList());
        if (intersect.isEmpty()) {
            return ActionResultType.PASS;
        }
        for (int a = 0; a < inv.getSlots(); ++a) {
            int id = LockingItem.getOrSetId(inv.getStackInSlot(a));
            List match = intersect.stream().filter(lkb -> lkb.lock.id == id).collect(Collectors.toList());
            if (match.isEmpty()) continue;
            world.func_184133_a(ctx.func_195999_j(), pos, (SoundEvent)LocksSoundEvents.LOCK_OPEN.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            for (Lockable lkb2 : match) {
                lkb2.lock.setLocked(!lkb2.lock.isLocked());
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }
}

