/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.network.toclient;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.function.Supplier;
import melonslise.locks.common.capability.ILockableHandler;
import melonslise.locks.common.capability.ILockableStorage;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.util.Lockable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.network.NetworkEvent;

public class AddLockableToChunkPacket {
    private final Lockable lockable;
    private final int x;
    private final int z;

    public AddLockableToChunkPacket(Lockable lkb, int x, int z) {
        this.lockable = lkb;
        this.x = x;
        this.z = z;
    }

    public AddLockableToChunkPacket(Lockable lkb, ChunkPos pos) {
        this(lkb, pos.field_77276_a, pos.field_77275_b);
    }

    public AddLockableToChunkPacket(Lockable lkb, Chunk ch) {
        this(lkb, ch.func_76632_l());
    }

    public static AddLockableToChunkPacket decode(PacketBuffer buf) {
        return new AddLockableToChunkPacket(Lockable.fromBuf(buf), buf.readInt(), buf.readInt());
    }

    public static void encode(AddLockableToChunkPacket pkt, PacketBuffer buf) {
        Lockable.toBuf(buf, pkt.lockable);
        buf.writeInt(pkt.x);
        buf.writeInt(pkt.z);
    }

    public static void handle(final AddLockableToChunkPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                Minecraft mc = Minecraft.func_71410_x();
                ILockableStorage st = (ILockableStorage)mc.field_71441_e.func_212866_a_(pkt.x, pkt.z).getCapability(LocksCapabilities.LOCKABLE_STORAGE).orElse(null);
                ILockableHandler handler = (ILockableHandler)mc.field_71441_e.getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null);
                Int2ObjectMap<Lockable> lkbs = handler.getLoaded();
                Lockable lkb = (Lockable)lkbs.get(((AddLockableToChunkPacket)pkt).lockable.id);
                if (lkb == lkbs.defaultReturnValue()) {
                    lkb = pkt.lockable;
                    lkb.addObserver(handler);
                    lkbs.put(lkb.id, (Object)lkb);
                }
                st.add(lkb);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

