/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import melonslise.locks.common.util.BiIntFunction;
import melonslise.locks.common.util.BiIntPredicate;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class Cuboid6i {
    public final int x1;
    public final int y1;
    public final int z1;
    public final int x2;
    public final int y2;
    public final int z2;
    public static final String KEY_X1 = "X1";
    public static final String KEY_Y1 = "Y1";
    public static final String KEY_Z1 = "Z1";
    public static final String KEY_X2 = "X2";
    public static final String KEY_Y2 = "Y2";
    public static final String KEY_Z2 = "Z2";

    public Cuboid6i(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.x1 = Math.min(x1, x2);
        this.y1 = Math.min(y1, y2);
        this.z1 = Math.min(z1, z2);
        this.x2 = Math.max(x1, x2);
        this.y2 = Math.max(y1, y2);
        this.z2 = Math.max(z1, z2);
    }

    public Cuboid6i(BlockPos pos1, BlockPos pos2) {
        this.x1 = Math.min(pos1.func_177958_n(), pos2.func_177958_n());
        this.y1 = Math.min(pos1.func_177956_o(), pos2.func_177956_o());
        this.z1 = Math.min(pos1.func_177952_p(), pos2.func_177952_p());
        this.x2 = Math.max(pos1.func_177958_n(), pos2.func_177958_n()) + 1;
        this.y2 = Math.max(pos1.func_177956_o(), pos2.func_177956_o()) + 1;
        this.z2 = Math.max(pos1.func_177952_p(), pos2.func_177952_p()) + 1;
    }

    public static Cuboid6i fromNbt(CompoundNBT nbt) {
        return new Cuboid6i(nbt.func_74762_e(KEY_X1), nbt.func_74762_e(KEY_Y1), nbt.func_74762_e(KEY_Z1), nbt.func_74762_e(KEY_X2), nbt.func_74762_e(KEY_Y2), nbt.func_74762_e(KEY_Z2));
    }

    public static CompoundNBT toNbt(Cuboid6i bb) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a(KEY_X1, bb.x1);
        nbt.func_74768_a(KEY_Y1, bb.y1);
        nbt.func_74768_a(KEY_Z1, bb.z1);
        nbt.func_74768_a(KEY_X2, bb.x2);
        nbt.func_74768_a(KEY_Y2, bb.y2);
        nbt.func_74768_a(KEY_Z2, bb.z2);
        return nbt;
    }

    public static Cuboid6i fromBuf(PacketBuffer buf) {
        return new Cuboid6i(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void toBuf(PacketBuffer buf, Cuboid6i bb) {
        buf.writeInt(bb.x1);
        buf.writeInt(bb.y1);
        buf.writeInt(bb.z1);
        buf.writeInt(bb.x2);
        buf.writeInt(bb.y2);
        buf.writeInt(bb.z2);
    }

    public Cuboid6i offset(int x, int y, int z) {
        return new Cuboid6i(this.x1 + x, this.y1 + y, this.z1 + z, this.x2 + x, this.y2 + y, this.z2 + z);
    }

    public Cuboid6i intersection(Cuboid6i other) {
        return new Cuboid6i(Math.max(this.x1, other.x1), Math.max(this.y1, other.y1), Math.max(this.z1, other.z1), Math.min(this.x2, other.x2), Math.min(this.y2, other.y2), Math.min(this.z2, other.z2));
    }

    public int length() {
        return this.x2 - this.x1;
    }

    public int height() {
        return this.y2 - this.y1;
    }

    public int width() {
        return this.z2 - this.z1;
    }

    public int volume() {
        return this.length() * this.height() * this.width();
    }

    public Vector3d center() {
        return new Vector3d((double)(this.x1 + this.x2) * 0.5, (double)(this.y1 + this.y2) * 0.5, (double)(this.z1 + this.z2) * 0.5);
    }

    public boolean intersects(int x1, int y1, int z1, int x2, int y2, int z2) {
        return this.x1 < x2 && this.x2 > x1 && this.y1 < y2 && this.y2 > y1 && this.z1 < z2 && this.z2 > z1;
    }

    public boolean intersects(Cuboid6i other) {
        return this.intersects(other.x1, other.y1, other.z1, other.x2, other.y2, other.z2);
    }

    public boolean intersects(BlockPos pos) {
        return this.intersects(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1);
    }

    public Iterable<BlockPos> getContainedPos() {
        return BlockPos.func_191531_b((int)this.x1, (int)this.y1, (int)this.z1, (int)(this.x2 - 1), (int)(this.y2 - 1), (int)(this.z2 - 1));
    }

    public boolean getContainedChunks(BiIntPredicate p) {
        int x1 = this.x1 >> 4;
        int x2 = this.x2 >> 4;
        int z1 = this.z1 >> 4;
        int z2 = this.z2 >> 4;
        if (this.x2 % 16 == 0) {
            --x2;
        }
        if (this.z2 % 16 == 0) {
            --z2;
        }
        int sizeX = x2 - x1 + 1;
        int length = sizeX * (z2 - z1 + 1);
        for (int a = 0; a < length; ++a) {
            if (!p.test(x1 + a / sizeX, z1 + a % sizeX)) continue;
            return false;
        }
        return true;
    }

    public <T> List<T> containedChunksTo(BiIntFunction<T> f, boolean endEarly) {
        int x1 = this.x1 >> 4;
        int x2 = this.x2 >> 4;
        int z1 = this.z1 >> 4;
        int z2 = this.z2 >> 4;
        if (this.x2 % 16 == 0) {
            --x2;
        }
        if (this.z2 % 16 == 0) {
            --z2;
        }
        int sizeX = x2 - x1 + 1;
        int length = sizeX * (z2 - z1 + 1);
        ArrayList<T> list = new ArrayList<T>(length);
        for (int a = 0; a < length; ++a) {
            T t = f.apply(x1 + a % sizeX, z1 + a / sizeX);
            if (endEarly && t == null) {
                return null;
            }
            list.add(a, t);
        }
        return list;
    }

    public Vector3d sideCenter(Direction side) {
        Vector3i dir = side.func_176730_m();
        return new Vector3d((double)(this.x1 + this.x2 + this.length() * dir.func_177958_n()) * 0.5, (double)(this.y1 + this.y2 + this.height() * dir.func_177956_o()) * 0.5, (double)(this.z1 + this.z2 + this.width() * dir.func_177952_p()) * 0.5);
    }

    public boolean isLoaded(World world) {
        return world.func_217344_a(this.x1, this.y1, this.z1, this.x2, this.y2, this.z2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Cuboid6i)) {
            return false;
        }
        Cuboid6i box = (Cuboid6i)object;
        return this.x1 == box.x1 && this.x2 == box.x2 && this.y1 == box.y1 && this.y2 == box.y2 && this.z1 == box.z1 && this.z2 == box.z2;
    }

    public int hashCode() {
        return Objects.hash(this.x1, this.y1, this.z1, this.x2, this.y2, this.z2);
    }

    public String toString() {
        return "Box{" + this.x1 + ", " + this.y1 + ", " + this.z1 + ", " + this.x2 + ", " + this.y2 + ", " + this.z2 + "}";
    }
}

