/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.util;

import java.util.Observable;
import java.util.Random;
import melonslise.locks.common.item.LockItem;
import melonslise.locks.common.item.LockingItem;
import melonslise.locks.common.util.LocksUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class Lock
extends Observable {
    public final int id;
    protected final byte[] combo;
    protected boolean locked;
    public final Random rng;
    public static final String KEY_ID = "Id";
    public static final String KEY_LENGTH = "Length";
    public static final String KEY_LOCKED = "Locked";

    public Lock(int id, int length, boolean locked) {
        this.id = id;
        this.rng = new Random(id);
        this.combo = this.shuffle(length);
        this.locked = locked;
    }

    public static Lock from(ItemStack stack) {
        return new Lock(LockingItem.getOrSetId(stack), LockItem.getOrSetLength(stack), !LockItem.isOpen(stack));
    }

    public static Lock fromNbt(CompoundNBT nbt) {
        return new Lock(nbt.func_74762_e(KEY_ID), nbt.func_74771_c(KEY_LENGTH), nbt.func_74767_n(KEY_LOCKED));
    }

    public static CompoundNBT toNbt(Lock lock) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a(KEY_ID, lock.id);
        nbt.func_74774_a(KEY_LENGTH, (byte)lock.combo.length);
        nbt.func_74757_a(KEY_LOCKED, lock.locked);
        return nbt;
    }

    public static Lock fromBuf(PacketBuffer buf) {
        return new Lock(buf.readInt(), buf.readByte(), buf.readBoolean());
    }

    public static void toBuf(PacketBuffer buf, Lock lock) {
        buf.writeInt(lock.id);
        buf.writeByte(lock.getLength());
        buf.writeBoolean(lock.isLocked());
    }

    public byte[] shuffle(int length) {
        byte[] combo = new byte[length];
        for (int a = 0; a < length; a = (int)((byte)(a + 1))) {
            combo[a] = a;
        }
        LocksUtil.shuffle(combo, this.rng);
        return combo;
    }

    public int getLength() {
        return this.combo.length;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        if (this.locked == locked) {
            return;
        }
        this.locked = locked;
        this.setChanged();
        this.notifyObservers();
    }

    public int getPin(int index) {
        return this.combo[index];
    }

    public boolean checkPin(int index, int pin) {
        return this.getPin(index) == pin;
    }
}

