/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Deque;
import java.util.Random;
import java.util.stream.Stream;
import melonslise.locks.common.capability.ILockableHandler;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.LocksPredicates;
import melonslise.locks.mixin.ForgeHooksAccessor;
import melonslise.locks.mixin.LootPoolAccessor;
import melonslise.locks.mixin.LootTableAccessor;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;

public final class LocksUtil {
    public static IResourceManager resourceManager;
    public static Constructor lootTableContextConstructor;

    private LocksUtil() {
    }

    public static void shuffle(byte[] array, Random rng) {
        for (int a = array.length - 1; a > 0; --a) {
            int index = rng.nextInt(a + 1);
            byte temp = array[index];
            array[index] = array[a];
            array[a] = temp;
        }
    }

    public static boolean chance(Random rng, double ch) {
        return ch == 1.0 || ch != 0.0 && rng.nextDouble() <= ch;
    }

    public static BlockPos transform(int x, int y, int z, PlacementSettings settings) {
        switch (settings.func_186212_b()) {
            case LEFT_RIGHT: {
                z = -z + 1;
                break;
            }
            case FRONT_BACK: {
                x = -x + 1;
                break;
            }
        }
        int x1 = settings.func_207664_d().func_177958_n();
        int z1 = settings.func_207664_d().func_177952_p();
        switch (settings.func_186215_c()) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(x1 - z1 + z, y, x1 + z1 - x + 1);
            }
            case CLOCKWISE_90: {
                return new BlockPos(x1 + z1 - z + 1, y, z1 - x1 + x);
            }
            case CLOCKWISE_180: {
                return new BlockPos(x1 + x1 - x + 1, y, z1 + z1 - z + 1);
            }
        }
        return new BlockPos(x, y, z);
    }

    public static AttachFace faceFromDir(Direction dir) {
        return dir == Direction.UP ? AttachFace.CEILING : (dir == Direction.DOWN ? AttachFace.FLOOR : AttachFace.WALL);
    }

    public static AxisAlignedBB rotateY(AxisAlignedBB bb) {
        return new AxisAlignedBB(bb.field_72339_c, bb.field_72338_b, bb.field_72340_a, bb.field_72334_f, bb.field_72337_e, bb.field_72336_d);
    }

    public static AxisAlignedBB rotateX(AxisAlignedBB bb) {
        return new AxisAlignedBB(bb.field_72340_a, bb.field_72339_c, bb.field_72338_b, bb.field_72336_d, bb.field_72334_f, bb.field_72337_e);
    }

    public static boolean intersectsInclusive(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return bb1.field_72340_a <= bb2.field_72336_d && bb1.field_72336_d >= bb2.field_72340_a && bb1.field_72338_b <= bb2.field_72337_e && bb1.field_72337_e >= bb2.field_72338_b && bb1.field_72339_c <= bb2.field_72334_f && bb1.field_72334_f >= bb2.field_72339_c;
    }

    public static Vector3d sideCenter(AxisAlignedBB bb, Direction side) {
        Vector3i dir = side.func_176730_m();
        return new Vector3d((bb.field_72340_a + bb.field_72336_d + (bb.field_72336_d - bb.field_72340_a) * (double)dir.func_177958_n()) * 0.5, (bb.field_72338_b + bb.field_72337_e + (bb.field_72337_e - bb.field_72338_b) * (double)dir.func_177956_o()) * 0.5, (bb.field_72339_c + bb.field_72334_f + (bb.field_72334_f - bb.field_72339_c) * (double)dir.func_177952_p()) * 0.5);
    }

    public static LootTable lootTableFrom(ResourceLocation loc) throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        JsonElement json = (JsonElement)JSONUtils.func_193839_a((Gson)LootTableManager.field_186526_b, (Reader)new BufferedReader(new InputStreamReader(resourceManager.func_199002_a(loc).func_199027_b(), StandardCharsets.UTF_8)), JsonElement.class);
        Deque que = ForgeHooksAccessor.getLootContext().get();
        Object lootCtx = lootTableContextConstructor.newInstance(loc, false);
        try {
            que.push(lootCtx);
            LootTable lootTable = (LootTable)LootTableManager.field_186526_b.fromJson(json, LootTable.class);
            return lootTable;
        }
        catch (JsonSyntaxException e) {
            throw e;
        }
        finally {
            que.pop();
        }
    }

    public static LootTable mergeEntries(LootTable table, LootTable inject) {
        for (LootPool injectPool : ((LootTableAccessor)inject).getPools()) {
            LootPool pool = table.getPool(injectPool.getName());
            if (pool == null) {
                table.addPool(injectPool);
                continue;
            }
            ((LootPoolAccessor)pool).getEntries().addAll(((LootPoolAccessor)injectPool).getEntries());
        }
        return table;
    }

    public static Stream<Lockable> intersecting(World world, BlockPos pos) {
        return ((ILockableHandler)world.getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null)).getInChunk(pos).values().stream().filter(lkb -> lkb.bb.intersects(pos));
    }

    public static boolean locked(World world, BlockPos pos) {
        return LocksUtil.intersecting(world, pos).anyMatch(LocksPredicates.LOCKED);
    }

    static {
        try {
            lootTableContextConstructor = Class.forName("net.minecraftforge.common.ForgeHooks$LootTableContext").getDeclaredConstructor(ResourceLocation.class, Boolean.TYPE);
            lootTableContextConstructor.setAccessible(true);
        }
        catch (ClassNotFoundException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
    }
}

