/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import melonslise.locks.common.capability.ILockableHandler;
import melonslise.locks.common.config.LocksConfig;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.util.Cuboid6i;
import melonslise.locks.common.util.Lock;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.LockableInfo;
import melonslise.locks.common.util.LocksUtil;
import melonslise.locks.common.util.Transform;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Template.class})
public class TemplateMixin {
    private final List<LockableInfo> lockableInfos = new ArrayList<LockableInfo>();
    private static final String KEY_LOCKABLES = "Lockables";

    @Inject(at={@At(value="HEAD")}, method={"fillFromWorld(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;ZLnet/minecraft/block/Block;)V"})
    private void fillFromWorld(World world, BlockPos start, BlockPos size, boolean takeEntities, @Nullable Block toIgnore, CallbackInfo ci) {
        if (size.func_177958_n() >= 1 && size.func_177956_o() >= 1 && size.func_177952_p() >= 1) {
            this.lockableInfos.clear();
            ILockableHandler handler = (ILockableHandler)world.getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null);
            Cuboid6i bb = new Cuboid6i(start, start.func_177982_a(size.func_177958_n() - 1, size.func_177956_o() - 1, size.func_177952_p() - 1));
            handler.getLoaded().values().stream().filter(lkb -> lkb.bb.intersects(bb)).forEach(lkb -> {
                Cuboid6i newBB = bb.intersection(lkb.bb).offset(-start.func_177958_n(), -start.func_177956_o(), -start.func_177952_p());
                this.lockableInfos.add(new LockableInfo(newBB, lkb.lock, lkb.tr, lkb.stack, lkb.id));
            });
        }
    }

    @Inject(at={@At(value="RETURN", ordinal=1)}, method={"placeInWorld(Lnet/minecraft/world/IServerWorld;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/gen/feature/template/PlacementSettings;Ljava/util/Random;I)Z"})
    private void placeInWorld(IServerWorld world, BlockPos start, BlockPos size, PlacementSettings settings, Random rng, int i, CallbackInfoReturnable<Boolean> cir) {
        ILockableHandler handler = (ILockableHandler)world.func_201672_e().getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null);
        for (LockableInfo lkb : this.lockableInfos) {
            BlockPos pos1 = LocksUtil.transform(lkb.bb.x1, lkb.bb.y1, lkb.bb.z1, settings);
            BlockPos pos2 = LocksUtil.transform(lkb.bb.x2, lkb.bb.y2, lkb.bb.z2, settings);
            Cuboid6i bb = new Cuboid6i(pos1.func_177958_n() + start.func_177958_n(), pos1.func_177956_o() + start.func_177956_o(), pos1.func_177952_p() + start.func_177952_p(), pos2.func_177958_n() + start.func_177958_n(), pos2.func_177956_o() + start.func_177956_o(), pos2.func_177952_p() + start.func_177952_p());
            ItemStack stack = (Boolean)LocksConfig.RANDOMIZE_LOADED_LOCKS.get() != false ? LocksConfig.getRandomLock(rng) : lkb.stack;
            Lock lock = (Boolean)LocksConfig.RANDOMIZE_LOADED_LOCKS.get() != false ? Lock.from(stack) : lkb.lock;
            Transform tr = Transform.fromDirectionAndFace(settings.func_186215_c().func_185831_a(settings.func_186212_b().func_185800_a(lkb.tr.dir).func_185831_a(lkb.tr.dir)), lkb.tr.face, Direction.NORTH);
            handler.add(new Lockable(bb, lock, tr, stack, (World)world.func_201672_e()));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"save(Lnet/minecraft/nbt/CompoundNBT;)Lnet/minecraft/nbt/CompoundNBT;"})
    private void save(CompoundNBT nbt, CallbackInfoReturnable<CompoundNBT> cir) {
        ListNBT list = new ListNBT();
        for (LockableInfo lkb : this.lockableInfos) {
            list.add((Object)LockableInfo.toNbt(lkb));
        }
        nbt.func_218657_a(KEY_LOCKABLES, (INBT)list);
    }

    @Inject(at={@At(value="HEAD")}, method={"load(Lnet/minecraft/nbt/CompoundNBT;)V"})
    private void read(CompoundNBT nbt, CallbackInfo ci) {
        this.lockableInfos.clear();
        ListNBT list = nbt.func_150295_c(KEY_LOCKABLES, 10);
        int b = list.size();
        for (int a = 0; a < b; ++a) {
            this.lockableInfos.add(LockableInfo.fromNbt(list.func_150305_b(a)));
        }
    }
}

