/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.lowtechcrafting.inventory;

import fi.dy.masa.lowtechcrafting.inventory.ItemStackHandlerBasic;
import fi.dy.masa.lowtechcrafting.inventory.wrapper.InventoryCraftingWrapper;
import fi.dy.masa.lowtechcrafting.util.EntityUtils;
import fi.dy.masa.lowtechcrafting.util.InventoryUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class ItemHandlerCraftResult
extends ItemStackHandlerBasic {
    @Nullable
    private World world;
    @Nullable
    private BlockPos pos = BlockPos.field_177992_a;
    @Nullable
    private EntityPlayer player;
    @Nullable
    private InventoryCraftingWrapper craftMatrix;
    @Nullable
    private IRecipe recipe;

    public ItemHandlerCraftResult() {
        super(1);
    }

    public void init(InventoryCraftingWrapper craftMatrix, World world, EntityPlayer player, BlockPos pos) {
        this.craftMatrix = craftMatrix;
        this.world = world;
        this.player = player;
        this.pos = pos;
    }

    public void setRecipe(@Nullable IRecipe recipe) {
        this.recipe = recipe;
    }

    @Nullable
    public IRecipe getRecipe() {
        return this.recipe;
    }

    @Override
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = super.extractItem(slot, this.getStackInSlot(slot).func_190916_E(), simulate);
        if (!simulate && this.player != null) {
            this.onCraft(this.player, stack);
        }
        return stack;
    }

    private void onCraft(ItemStack stack) {
        stack.func_77980_a(this.world, this.player, stack.func_190916_E());
        FMLCommonHandler.instance().firePlayerCraftingEvent(this.player, stack, (IInventory)this.craftMatrix);
        IRecipe recipe = this.getRecipe();
        if (recipe != null && !recipe.func_192399_d()) {
            this.setRecipe(null);
        }
    }

    private void onCraft(EntityPlayer player, ItemStack stack) {
        this.onCraft(stack);
        ForgeHooks.setCraftingPlayer((EntityPlayer)player);
        NonNullList remainingItems = CraftingManager.func_180303_b((InventoryCrafting)this.craftMatrix, (World)player.func_130014_f_());
        ForgeHooks.setCraftingPlayer(null);
        this.craftMatrix.setInhibitResultUpdate(true);
        for (int slot = 0; slot < remainingItems.size(); ++slot) {
            ItemStack stackInSlot = this.craftMatrix.func_70301_a(slot);
            ItemStack remainingItemsInSlot = (ItemStack)remainingItems.get(slot);
            if (!stackInSlot.func_190926_b()) {
                this.craftMatrix.func_70298_a(slot, 1);
                stackInSlot = this.craftMatrix.func_70301_a(slot);
            }
            if (remainingItemsInSlot.func_190926_b()) continue;
            if (stackInSlot.func_190926_b()) {
                this.craftMatrix.func_70299_a(slot, remainingItemsInSlot);
                continue;
            }
            if (InventoryUtils.areItemStacksEqual(stackInSlot, remainingItemsInSlot)) {
                remainingItemsInSlot.func_190917_f(stackInSlot.func_190916_E());
                this.craftMatrix.func_70299_a(slot, remainingItemsInSlot);
                continue;
            }
            EntityUtils.dropItemStacksInWorld(this.world, this.pos, remainingItemsInSlot, -1, true);
        }
        this.craftMatrix.setInhibitResultUpdate(false);
        this.craftMatrix.func_70296_d();
    }
}

