/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.lowtechcrafting.inventory;

import fi.dy.masa.lowtechcrafting.inventory.IItemHandlerSelective;
import fi.dy.masa.lowtechcrafting.inventory.IItemHandlerSize;
import fi.dy.masa.lowtechcrafting.util.NBTUtils;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemStackHandlerBasic
implements IItemHandlerModifiable,
INBTSerializable<NBTTagCompound>,
IItemHandlerSelective,
IItemHandlerSize {
    protected final NonNullList<ItemStack> items;
    private final boolean allowCustomStackSizes;
    private int inventorySize;
    private int stackLimit;
    private String tagName;

    public ItemStackHandlerBasic(int invSize) {
        this(invSize, 64, false, "Items");
    }

    public ItemStackHandlerBasic(int invSize, int stackLimit, boolean allowCustomStackSizes, String tagName) {
        this.inventorySize = invSize;
        this.tagName = tagName;
        this.allowCustomStackSizes = allowCustomStackSizes;
        this.items = NonNullList.func_191197_a((int)invSize, (Object)ItemStack.field_190927_a);
        this.setStackLimit(stackLimit);
    }

    public void setInventorySize(int invSize) {
        this.inventorySize = MathHelper.func_76125_a((int)invSize, (int)0, (int)this.items.size());
    }

    public int getSlots() {
        return this.inventorySize;
    }

    public int getSlotLimit(int slot) {
        return this.stackLimit;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.items.set(slot, (Object)(stack.func_190926_b() ? ItemStack.field_190927_a : stack));
        this.onContentsChanged(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b() || !this.isItemValidForSlot(slot, stack)) {
            return stack;
        }
        ItemStack existingStack = (ItemStack)this.items.get(slot);
        boolean hasStack = !existingStack.func_190926_b();
        int existingStackSize = hasStack ? existingStack.func_190916_E() : 0;
        int max = this.getItemStackLimit(slot, stack);
        if (!this.allowCustomStackSizes) {
            max = Math.min(max, stack.func_77976_d());
        } else if (stack.func_77976_d() == 1) {
            max = 1;
        }
        if (hasStack && (existingStackSize >= max || stack.func_77973_b() != existingStack.func_77973_b() || stack.func_77960_j() != existingStack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)existingStack))) {
            return stack;
        }
        int amount = Math.min(max - existingStackSize, stack.func_190916_E());
        if (amount <= 0) {
            return stack;
        }
        if (!simulate) {
            if (hasStack) {
                existingStack.func_190917_f(amount);
            } else {
                ItemStack newStack = stack.func_77946_l();
                newStack.func_190920_e(amount);
                this.items.set(slot, (Object)newStack);
            }
            this.onContentsChanged(slot);
        }
        if (amount < stack.func_190916_E()) {
            ItemStack stackRemaining = stack.func_77946_l();
            stackRemaining.func_190918_g(amount);
            return stackRemaining;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack;
        if (!this.canExtractFromSlot(slot)) {
            return ItemStack.field_190927_a;
        }
        ItemStack existingStack = (ItemStack)this.items.get(slot);
        if (existingStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        amount = Math.min(amount, Math.min(existingStack.func_190916_E(), existingStack.func_77976_d()));
        if (simulate) {
            ItemStack stack2 = existingStack.func_77946_l();
            stack2.func_190920_e(amount);
            return stack2;
        }
        if (amount == existingStack.func_190916_E()) {
            stack = existingStack;
            this.items.set(slot, (Object)ItemStack.field_190927_a);
        } else {
            stack = existingStack.func_77979_a(amount);
            if (existingStack.func_190916_E() <= 0) {
                this.items.set(slot, (Object)ItemStack.field_190927_a);
            }
        }
        this.onContentsChanged(slot);
        return stack;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound wrapper = new NBTTagCompound();
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.inventorySize != this.items.size()) {
            nbt.func_74774_a("SlotCount", (byte)this.inventorySize);
        }
        NBTUtils.writeItemsToTag(nbt, this.items, "Items", true);
        wrapper.func_74782_a(this.tagName, (NBTBase)nbt);
        return wrapper;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if ((nbt = nbt.func_74775_l(this.tagName)).func_150297_b("SlotCount", 1)) {
            this.setInventorySize(nbt.func_74771_c("SlotCount"));
        }
        NBTUtils.readStoredItemsFromTag(nbt, this.items, "Items");
    }

    @Override
    public int getInventoryStackLimit() {
        return this.stackLimit;
    }

    @Override
    public int getItemStackLimit(int slot, ItemStack stack) {
        if (this.allowCustomStackSizes) {
            return this.getInventoryStackLimit();
        }
        return Math.min(stack.func_77976_d(), this.getSlotLimit(slot));
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public boolean canExtractFromSlot(int slot) {
        return true;
    }

    public void setStackLimit(int stackLimit) {
        this.stackLimit = stackLimit;
    }

    public void onContentsChanged(int slot) {
    }

    public void setItemStorageTagName(@Nonnull String tagName) {
        this.tagName = tagName;
    }

    public String getItemStorageTagName() {
        return this.tagName;
    }
}

