/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.lowtechcrafting.inventory.wrapper;

import fi.dy.masa.lowtechcrafting.inventory.ItemHandlerCraftResult;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;

public class InventoryCraftingWrapper
extends InventoryCrafting {
    private final int inventoryWidth;
    private final int inventoryHeight;
    private final ItemHandlerCraftResult craftResult;
    private IItemHandlerModifiable craftMatrix;
    @Nullable
    private EntityPlayerMP player;
    private boolean inhibitResultUpdate;

    public InventoryCraftingWrapper(int width, int height, IItemHandlerModifiable craftMatrix, ItemHandlerCraftResult resultInventory) {
        super(null, 0, 0);
        this.inventoryWidth = width;
        this.inventoryHeight = height;
        this.craftMatrix = craftMatrix;
        this.craftResult = resultInventory;
    }

    public void setPlayer(EntityPlayerMP player) {
        this.player = player;
    }

    public void setCraftMatrix(IItemHandlerModifiable craftMatrix) {
        this.craftMatrix = craftMatrix;
    }

    public void setInhibitResultUpdate(boolean inhibitUpdate) {
        this.inhibitResultUpdate = inhibitUpdate;
    }

    public int func_174923_h() {
        return this.inventoryHeight;
    }

    public int func_174922_i() {
        return this.inventoryWidth;
    }

    public int func_70302_i_() {
        return this.craftMatrix.getSlots();
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= this.func_70302_i_() ? ItemStack.field_190927_a : this.craftMatrix.getStackInSlot(slot);
    }

    public boolean func_191420_l() {
        int invSize = this.craftMatrix.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            if (this.func_70301_a(slot).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70463_b(int row, int column) {
        if (row >= 0 && row < this.inventoryWidth && column >= 0 && column <= this.inventoryHeight) {
            return this.func_70301_a(row + column * this.inventoryWidth);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int slot) {
        return this.craftMatrix.extractItem(slot, this.craftMatrix.getStackInSlot(slot).func_190916_E(), false);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stackOrig = this.craftMatrix.getStackInSlot(slot);
        ItemStack stackReturn = stackOrig.func_77946_l();
        amount = Math.min(amount, stackOrig.func_190916_E());
        stackReturn.func_190920_e(amount);
        stackOrig.func_190918_g(amount);
        this.craftMatrix.setStackInSlot(slot, stackOrig);
        if (!stackReturn.func_190926_b()) {
            this.func_70296_d();
        }
        return stackReturn;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.craftMatrix.setStackInSlot(slot, stack);
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return this.craftMatrix.getSlotLimit(0);
    }

    public void func_174888_l() {
        for (int slot = 0; slot < this.craftMatrix.getSlots(); ++slot) {
            this.craftMatrix.setStackInSlot(slot, ItemStack.field_190927_a);
        }
        this.func_70296_d();
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.updateCraftingOutput();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    private void setCraftResult(@Nonnull ItemStack stack) {
        this.craftResult.setStackInSlot(0, stack);
    }

    public void updateCraftingOutput() {
        if (!this.inhibitResultUpdate && this.player != null && !this.player.func_130014_f_().field_72995_K) {
            World world = this.player.func_130014_f_();
            IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)this, (World)world);
            ItemStack stack = ItemStack.field_190927_a;
            if (recipe != null) {
                this.craftResult.setRecipe(recipe);
                stack = recipe.func_77572_b((InventoryCrafting)this);
            }
            this.setCraftResult(stack);
        }
    }

    public void func_194018_a(RecipeItemHelper recipeItemHelper) {
        int invSize = this.craftMatrix.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            recipeItemHelper.func_194112_a(this.craftMatrix.getStackInSlot(slot));
        }
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }
}

