/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.lowtechcrafting.network.message;

import fi.dy.masa.lowtechcrafting.LowTechCrafting;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public class ByteBufUtilsLTC {
    public static void writeItemStackToBuffer(ByteBuf buf, ItemStack stack) {
        if (stack.func_190926_b()) {
            buf.writeShort(-1);
            return;
        }
        buf.writeShort(Item.func_150891_b((Item)stack.func_77973_b()));
        buf.writeShort(stack.func_77960_j());
        buf.writeInt(stack.func_190916_E());
        NBTTagCompound tag = null;
        if (stack.func_77973_b().func_77645_m() || stack.func_77973_b().func_77651_p()) {
            tag = stack.func_77973_b().getNBTShareTag(stack);
        }
        ByteBufUtilsLTC.writeNBTTagCompoundToBuffer(buf, tag);
    }

    public static ItemStack readItemStackFromBuffer(ByteBuf buf) throws IOException {
        ItemStack stack = ItemStack.field_190927_a;
        short id = buf.readShort();
        if (id >= 0) {
            short meta = buf.readShort();
            int stackSize = buf.readInt();
            stack = new ItemStack(Item.func_150899_d((int)id), stackSize, (int)meta);
            stack.func_77982_d(ByteBufUtilsLTC.readNBTTagCompoundFromBuffer(buf));
        }
        return stack;
    }

    public static void writeNBTTagCompoundToBuffer(ByteBuf buf, NBTTagCompound tag) {
        if (tag == null) {
            buf.writeByte(0);
            return;
        }
        try {
            CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)new ByteBufOutputStream(buf));
        }
        catch (IOException ioexception) {
            LowTechCrafting.logger.error("IOException while trying to write a NBTTagCompound to ByteBuf");
            throw new EncoderException((Throwable)ioexception);
        }
    }

    public static NBTTagCompound readNBTTagCompoundFromBuffer(ByteBuf buf) throws IOException {
        int i = buf.readerIndex();
        byte b0 = buf.readByte();
        if (b0 == 0) {
            return null;
        }
        buf.readerIndex(i);
        return CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream(buf), (NBTSizeTracker)new NBTSizeTracker(0x200000L));
    }
}

