/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.lowtechcrafting.tileentity;

import com.mojang.authlib.GameProfile;
import fi.dy.masa.lowtechcrafting.inventory.ItemHandlerCraftResult;
import fi.dy.masa.lowtechcrafting.inventory.ItemStackHandlerTileEntity;
import fi.dy.masa.lowtechcrafting.inventory.wrapper.InventoryCraftingWrapper;
import fi.dy.masa.lowtechcrafting.inventory.wrapper.ItemHandlerWrapperCrafter;
import fi.dy.masa.lowtechcrafting.util.InventoryUtils;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityCrafting
extends TileEntity {
    private ItemStackHandlerTileEntity itemHandlerCraftingGrid = new ItemStackHandlerTileEntity(0, 9, 64, false, "Items", this);
    private ItemStackHandlerTileEntity itemHandlerOutput = new ItemStackHandlerTileEntity(1, 1, 64, false, "ItemsOut", this);
    private InventoryCraftingWrapper inventoryCrafting;
    private ItemHandlerCraftResult itemHandlerCraftResult = new ItemHandlerCraftResult();
    private ItemHandlerWrapperCrafter itemHandlerWrapperCrafter;
    private IItemHandler itemHandlerExternal;
    private String customInventoryName;
    private FakePlayer fakePlayer;
    private final String tileEntityName;

    public TileEntityCrafting() {
        this.tileEntityName = "crafting_table";
        this.inventoryCrafting = new InventoryCraftingWrapper(3, 3, this.itemHandlerCraftingGrid, this.itemHandlerCraftResult);
        this.itemHandlerWrapperCrafter = new ItemHandlerWrapperCrafter(this.itemHandlerCraftingGrid, this.itemHandlerOutput, this.itemHandlerCraftResult, this.inventoryCrafting);
        this.itemHandlerExternal = new ItemHandlerWrapperCrafterExternal(this.itemHandlerWrapperCrafter);
    }

    public InventoryCraftingWrapper getCraftingGridWrapperInventory() {
        return this.inventoryCrafting;
    }

    public ItemHandlerCraftResult getCraftResultInventory() {
        return this.itemHandlerCraftResult;
    }

    public IItemHandler getCraftingWrapperInventory() {
        return this.itemHandlerWrapperCrafter;
    }

    public void onLoad() {
        if (!this.func_145831_w().field_72995_K) {
            FakePlayer player = this.getPlayer();
            this.inventoryCrafting.setPlayer((EntityPlayerMP)player);
            this.itemHandlerCraftResult.init(this.inventoryCrafting, this.func_145831_w(), (EntityPlayer)player, this.func_174877_v());
        }
    }

    public void dropInventories() {
        InventoryUtils.dropInventoryContentsInWorld(this.func_145831_w(), this.func_174877_v(), this.itemHandlerCraftingGrid);
        InventoryUtils.dropInventoryContentsInWorld(this.func_145831_w(), this.func_174877_v(), this.itemHandlerOutput);
    }

    @Nonnull
    protected FakePlayer getPlayer() {
        if (this.fakePlayer == null && this.func_145831_w() instanceof WorldServer) {
            int dim = this.func_145831_w().field_73011_w.getDimension();
            this.fakePlayer = FakePlayerFactory.get((WorldServer)((WorldServer)this.func_145831_w()), (GameProfile)new GameProfile(new UUID(dim, dim), "lowtechcrafting:" + this.tileEntityName));
        }
        return this.fakePlayer;
    }

    public void readFromNBTCustom(NBTTagCompound nbt) {
        this.itemHandlerCraftingGrid.deserializeNBT(nbt);
        this.itemHandlerOutput.deserializeNBT(nbt);
        if (nbt.func_150297_b("CustomName", 8)) {
            this.customInventoryName = nbt.func_74779_i("CustomName");
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readFromNBTCustom(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_179237_a(this.itemHandlerCraftingGrid.serializeNBT());
        nbt.func_179237_a(this.itemHandlerOutput.serializeNBT());
        if (this.hasCustomName()) {
            nbt.func_74778_a("CustomName", this.customInventoryName);
        }
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("x", this.func_174877_v().func_177958_n());
        nbt.func_74768_a("y", this.func_174877_v().func_177956_o());
        nbt.func_74768_a("z", this.func_174877_v().func_177952_p());
        return nbt;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        if (this.func_145831_w() != null) {
            return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerExternal != null;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandlerExternal);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void inventoryChanged(int inventoryId, int slot) {
    }

    public void setInventoryName(String name) {
        this.customInventoryName = name;
    }

    public boolean hasCustomName() {
        return this.customInventoryName != null && this.customInventoryName.length() > 0;
    }

    public String getName() {
        return this.hasCustomName() ? this.customInventoryName : "tile." + this.tileEntityName + ".name";
    }

    public static class ItemHandlerWrapperCrafterExternal
    implements IItemHandler {
        private final IItemHandler inventoryCrafter;

        public ItemHandlerWrapperCrafterExternal(IItemHandler inventoryCrafter) {
            this.inventoryCrafter = inventoryCrafter;
        }

        public int getSlots() {
            return this.inventoryCrafter.getSlots();
        }

        public int getSlotLimit(int slot) {
            return this.inventoryCrafter.getSlotLimit(slot);
        }

        public ItemStack getStackInSlot(int slot) {
            return this.inventoryCrafter.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot == 0) {
                return stack;
            }
            if (this.inventoryCrafter.getStackInSlot(slot).func_190916_E() > 0) {
                return stack;
            }
            if (stack.func_190916_E() > 1) {
                ItemStack stackInsert = stack.func_77946_l();
                stackInsert.func_190920_e(1);
                stackInsert = this.inventoryCrafter.insertItem(slot, stackInsert, simulate);
                if (stackInsert.func_190926_b()) {
                    stack = stack.func_77946_l();
                    stack.func_190918_g(1);
                    return stack;
                }
                return stack;
            }
            return this.inventoryCrafter.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.inventoryCrafter.extractItem(slot, amount, simulate);
        }
    }
}

