/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.lowtechcrafting.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;

public class NBTUtils {
    @Nonnull
    public static ItemStack setRootCompoundTag(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (nbt != null && nbt.func_82582_d()) {
            nbt = null;
        }
        stack.func_77982_d(nbt);
        return stack;
    }

    @Nullable
    public static NBTTagCompound getRootCompoundTag(@Nonnull ItemStack stack, boolean create) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (!create) {
            return nbt;
        }
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        return nbt;
    }

    @Nullable
    public static NBTTagCompound getCompoundTag(@Nullable NBTTagCompound nbt, @Nonnull String tagName, boolean create) {
        if (nbt == null) {
            return null;
        }
        if (!create) {
            return nbt.func_150297_b(tagName, 10) ? nbt.func_74775_l(tagName) : null;
        }
        if (!nbt.func_150297_b(tagName, 10)) {
            nbt.func_74782_a(tagName, (NBTBase)new NBTTagCompound());
        }
        return nbt.func_74775_l(tagName);
    }

    @Nullable
    public static NBTTagCompound getCompoundTag(@Nonnull ItemStack stack, @Nullable String tagName, boolean create) {
        NBTTagCompound nbt = NBTUtils.getRootCompoundTag(stack, create);
        if (tagName != null) {
            nbt = NBTUtils.getCompoundTag(nbt, tagName, create);
        }
        return nbt;
    }

    public static byte getByte(@Nonnull ItemStack stack, @Nullable String containerTagName, @Nonnull String tagName) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, false);
        return nbt != null ? nbt.func_74771_c(tagName) : (byte)0;
    }

    public static void setByte(@Nonnull ItemStack stack, @Nullable String containerTagName, @Nonnull String tagName, byte value) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, true);
        nbt.func_74774_a(tagName, value);
    }

    public static void cycleByteValue(@Nonnull NBTTagCompound nbt, @Nonnull String tagName, int minValue, int maxValue, boolean reverse) {
        byte value = nbt.func_74771_c(tagName);
        if (reverse) {
            if ((value = (byte)(value - 1)) < minValue) {
                value = (byte)maxValue;
            }
        } else if ((value = (byte)(value + 1)) > maxValue) {
            value = (byte)minValue;
        }
        nbt.func_74774_a(tagName, value);
    }

    public static void cycleByteValue(@Nonnull ItemStack stack, @Nullable String containerTagName, @Nonnull String tagName, int maxValue, boolean reverse) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, true);
        NBTUtils.cycleByteValue(nbt, tagName, 0, maxValue, reverse);
    }

    public static void readByteArrayIntoIntArray(int[] arr, NBTTagCompound nbt, String tagName) {
        byte[] arrBytes = nbt.func_74770_j(tagName);
        int len = Math.min(arr.length, arrBytes.length);
        for (int i = 0; i < len; ++i) {
            arr[i] = arrBytes[i];
        }
    }

    public static void writeIntArrayAsByteArray(int[] arr, NBTTagCompound nbt, String tagName) {
        byte[] bytes = new byte[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            bytes[i] = (byte)arr[i];
        }
        nbt.func_74773_a(tagName, bytes);
    }

    public static void readByteArray(byte[] arr, NBTTagCompound nbt, String tagName) {
        byte[] arrNbt = nbt.func_74770_j(tagName);
        int len = Math.min(arr.length, arrNbt.length);
        for (int i = 0; i < len; ++i) {
            arr[i] = arrNbt[i];
        }
    }

    public static void readIntArray(int[] arr, NBTTagCompound nbt, String tagName) {
        int[] arrNbt = nbt.func_74759_k(tagName);
        int len = Math.min(arr.length, arrNbt.length);
        for (int i = 0; i < len; ++i) {
            arr[i] = arrNbt[i];
        }
    }

    @Nonnull
    public static ItemStack loadItemStackFromTag(@Nonnull NBTTagCompound tag) {
        ItemStack stack = new ItemStack(tag);
        if (tag.func_150297_b("ActualCount", 3)) {
            stack.func_190920_e(tag.func_74762_e("ActualCount"));
        }
        return stack.func_190926_b() ? ItemStack.field_190927_a : stack;
    }

    @Nonnull
    public static NBTTagCompound storeItemStackInTag(@Nonnull ItemStack stack, @Nonnull NBTTagCompound tag) {
        if (!stack.func_190926_b()) {
            stack.func_77955_b(tag);
            if (stack.func_190916_E() > 127) {
                tag.func_74774_a("Count", (byte)(stack.func_190916_E() & 0x7F));
                tag.func_74768_a("ActualCount", stack.func_190916_E());
            }
        }
        return tag;
    }

    public static void readStoredItemsFromTag(@Nonnull NBTTagCompound nbt, NonNullList<ItemStack> items, @Nonnull String tagName) {
        if (!nbt.func_150297_b(tagName, 9)) {
            return;
        }
        NBTTagList nbtTagList = nbt.func_150295_c(tagName, 10);
        int num = nbtTagList.func_74745_c();
        int listSize = items.size();
        for (int i = 0; i < num; ++i) {
            NBTTagCompound tag = nbtTagList.func_150305_b(i);
            short slotNum = tag.func_74765_d("Slot");
            if (slotNum < 0 || slotNum >= listSize) continue;
            items.set((int)slotNum, (Object)NBTUtils.loadItemStackFromTag(tag));
        }
    }

    @Nonnull
    public static NonNullList<ItemStack> readStoredItemsFromTag(@Nonnull NBTTagCompound nbt, @Nonnull String tagName) {
        NonNullList items = NonNullList.func_191196_a();
        if (!nbt.func_150297_b(tagName, 9)) {
            return items;
        }
        NBTTagList nbtTagList = nbt.func_150295_c(tagName, 10);
        int size = nbtTagList.func_74745_c();
        for (int i = 0; i < size; ++i) {
            NBTTagCompound tag = nbtTagList.func_150305_b(i);
            items.add((Object)NBTUtils.loadItemStackFromTag(tag));
        }
        return items;
    }

    @Nonnull
    public static NBTTagList createTagListForItems(NonNullList<ItemStack> items) {
        NBTTagList nbtTagList = new NBTTagList();
        int invSlots = items.size();
        for (int slotNum = 0; slotNum < invSlots; ++slotNum) {
            ItemStack stack = (ItemStack)items.get(slotNum);
            if (stack.func_190926_b()) continue;
            NBTTagCompound tag = NBTUtils.storeItemStackInTag(stack, new NBTTagCompound());
            if (invSlots <= 127) {
                tag.func_74774_a("Slot", (byte)slotNum);
            } else {
                tag.func_74777_a("Slot", (short)slotNum);
            }
            nbtTagList.func_74742_a((NBTBase)tag);
        }
        return nbtTagList;
    }

    @Nonnull
    public static NBTTagCompound writeItemsToTag(@Nonnull NBTTagCompound nbt, NonNullList<ItemStack> items, @Nonnull String tagName, boolean keepExtraSlots) {
        int invSlots = items.size();
        NBTTagList nbtTagList = NBTUtils.createTagListForItems(items);
        if (keepExtraSlots && nbt.func_150297_b(tagName, 9)) {
            NBTTagList nbtTagListExisting = nbt.func_150295_c(tagName, 10);
            int count = nbtTagListExisting.func_74745_c();
            for (int i = 0; i < count; ++i) {
                NBTTagCompound tag = nbtTagListExisting.func_150305_b(i);
                short slotNum = tag.func_74765_d("Slot");
                if (slotNum < invSlots) continue;
                nbtTagList.func_74742_a((NBTBase)tag);
            }
        }
        if (nbtTagList.func_74745_c() > 0) {
            nbt.func_74782_a(tagName, (NBTBase)nbtTagList);
        } else {
            nbt.func_82580_o(tagName);
        }
        return nbt;
    }
}

