/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.lowtechcrafting.blocks;

import fi.dy.masa.lowtechcrafting.tileentity.TileEntityCrafting;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockCraftingTable
extends Block {
    public static final ResourceLocation CONTENTS = new ResourceLocation("contents");

    public BlockCraftingTable() {
        super(Block.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a));
        this.func_180632_j((BlockState)this.field_176227_L.func_177621_b());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityCrafting();
    }

    public boolean isTileEntityValid(TileEntity te) {
        return te != null && !te.func_145837_r();
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityCrafting) {
                ((TileEntityCrafting)te).dropInventories();
                world.func_175666_e(pos, (Block)this);
            }
            world.func_175713_t(pos);
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityCrafting) {
            TileEntityCrafting tec = (TileEntityCrafting)te;
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt != null && nbt.func_150297_b("BlockEntityTag", 10)) {
                tec.readFromNBTCustom(nbt.func_74775_l("BlockEntityTag"));
            } else if (stack.func_82837_s()) {
                tec.setInventoryName(stack.func_200301_q().getString());
            }
        }
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityCrafting && this.isTileEntityValid(te)) {
            if (!world.field_72995_K && player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((TileEntityCrafting)te), (BlockPos)pos);
            }
            return true;
        }
        return false;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        LazyOptional optional;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && this.isTileEntityValid(te) && (optional = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.NORTH)).isPresent()) {
            return BlockCraftingTable.calcRedstoneFromInventory((IItemHandler)optional.orElse(null));
        }
        return 0;
    }

    public static int calcRedstoneFromInventory(@Nullable IItemHandler inv) {
        int numSlots;
        if (inv != null && (numSlots = inv.getSlots()) > 0) {
            int nonEmptyStacks = 0;
            for (int slot = 1; slot < numSlots; ++slot) {
                ItemStack stack = inv.getStackInSlot(slot);
                if (stack.func_190926_b()) continue;
                ++nonEmptyStacks;
            }
            return nonEmptyStacks * 15 / 9;
        }
        return 0;
    }
}

