/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.lowtechcrafting.inventory;

import fi.dy.masa.lowtechcrafting.inventory.ItemStackHandlerBasic;
import fi.dy.masa.lowtechcrafting.inventory.wrapper.InventoryCraftingWrapper;
import fi.dy.masa.lowtechcrafting.util.EntityUtils;
import fi.dy.masa.lowtechcrafting.util.InventoryUtils;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.hooks.BasicEventHooks;

public class ItemHandlerCraftResult
extends ItemStackHandlerBasic {
    private final Supplier<World> worldSupplier;
    private final Supplier<PlayerEntity> playerSupplier;
    private final Supplier<BlockPos> posSupplier;
    @Nullable
    private World world;
    @Nullable
    private PlayerEntity player;
    @Nullable
    private BlockPos pos;
    @Nullable
    private InventoryCraftingWrapper craftMatrix;
    @Nullable
    private ICraftingRecipe recipe;

    public ItemHandlerCraftResult(Supplier<World> worldSupplier, Supplier<PlayerEntity> playerSupplier, Supplier<BlockPos> posSupplier) {
        super(1);
        this.worldSupplier = worldSupplier;
        this.playerSupplier = playerSupplier;
        this.posSupplier = posSupplier;
    }

    public void setCraftMatrix(InventoryCraftingWrapper craftMatrix) {
        this.craftMatrix = craftMatrix;
    }

    public void setRecipe(@Nullable ICraftingRecipe recipe) {
        this.recipe = recipe;
    }

    @Nullable
    public ICraftingRecipe getRecipe() {
        return this.recipe;
    }

    @Nullable
    private World getWorld() {
        if (this.world == null) {
            this.world = this.worldSupplier.get();
        }
        return this.world;
    }

    @Nullable
    private PlayerEntity getPlayer() {
        if (this.player == null) {
            this.player = this.playerSupplier.get();
        }
        return this.player;
    }

    @Nullable
    private BlockPos getPos() {
        if (this.pos == null) {
            this.pos = this.posSupplier.get();
        }
        return this.pos;
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        this.craftMatrix.updateCraftingOutput();
        return super.getStackInSlot(slot);
    }

    @Override
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.craftMatrix.updateCraftingOutput();
        ItemStack stack = super.extractItem(slot, this.getStackInSlot(slot).func_190916_E(), true);
        if (!simulate) {
            this.onCraft(stack);
        }
        return stack;
    }

    private void onCraft(ItemStack stack) {
        PlayerEntity player = this.getPlayer();
        World world = this.getWorld();
        BlockPos pos = this.getPos();
        if (player == null || world == null || pos == null) {
            return;
        }
        stack.func_77980_a(world, player, stack.func_190916_E());
        BasicEventHooks.firePlayerCraftingEvent((PlayerEntity)player, (ItemStack)stack, (IInventory)this.craftMatrix);
        ForgeHooks.setCraftingPlayer((PlayerEntity)player);
        NonNullList<ItemStack> remainingItems = this.getRemainingItems();
        ForgeHooks.setCraftingPlayer(null);
        this.craftMatrix.setInhibitResultUpdate(true);
        this.craftMatrix.onCraft();
        for (int slot = 0; slot < remainingItems.size(); ++slot) {
            ItemStack stackInSlot = this.craftMatrix.func_70301_a(slot);
            ItemStack remainingItemsInSlot = (ItemStack)remainingItems.get(slot);
            if (!stackInSlot.func_190926_b()) {
                this.craftMatrix.func_70298_a(slot, 1);
                stackInSlot = this.craftMatrix.func_70301_a(slot);
            }
            if (remainingItemsInSlot.func_190926_b()) continue;
            if (stackInSlot.func_190926_b()) {
                this.craftMatrix.func_70299_a(slot, remainingItemsInSlot);
                continue;
            }
            if (InventoryUtils.areItemStacksEqual(stackInSlot, remainingItemsInSlot)) {
                remainingItemsInSlot.func_190917_f(stackInSlot.func_190916_E());
                this.craftMatrix.func_70299_a(slot, remainingItemsInSlot);
                continue;
            }
            EntityUtils.dropItemStacksInWorld(world, pos, remainingItemsInSlot, -1, true);
        }
        this.craftMatrix.setInhibitResultUpdate(false);
    }

    private NonNullList<ItemStack> getRemainingItems() {
        if (this.recipe != null) {
            return this.recipe.func_179532_b((IInventory)this.craftMatrix);
        }
        NonNullList items = NonNullList.func_191197_a((int)this.craftMatrix.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < items.size(); ++i) {
            items.set(i, (Object)this.craftMatrix.func_70301_a(i));
        }
        return items;
    }
}

