/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.lowtechcrafting.inventory.container.base;

import fi.dy.masa.lowtechcrafting.LowTechCrafting;
import fi.dy.masa.lowtechcrafting.inventory.container.base.MergeSlotRange;
import fi.dy.masa.lowtechcrafting.inventory.container.base.SlotRange;
import fi.dy.masa.lowtechcrafting.inventory.slot.SlotItemHandlerGeneric;
import fi.dy.masa.lowtechcrafting.inventory.wrapper.PlayerInvWrapperNoSync;
import fi.dy.masa.lowtechcrafting.network.PacketHandler;
import fi.dy.masa.lowtechcrafting.network.message.MessageSyncSlot;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerBase
extends Container {
    public static final int GUI_ACTION_SCROLL_MOVE = 0;
    public static final int GUI_ACTION_SCROLL_SET = 1;
    protected final PlayerEntity player;
    protected final boolean isClient;
    protected final PlayerInventory playerInventory;
    protected final IItemHandlerModifiable playerInv;
    protected final IItemHandler inventory;
    protected MergeSlotRange customInventorySlots;
    protected MergeSlotRange playerMainSlots;
    protected MergeSlotRange playerHotbarSlots;
    protected MergeSlotRange playerMainSlotsIncHotbar;
    protected MergeSlotRange playerOffhandSlots;
    protected MergeSlotRange playerArmorSlots;
    protected List<MergeSlotRange> mergeSlotRangesExtToPlayer;
    protected List<MergeSlotRange> mergeSlotRangesPlayerToExt;
    protected final List<IContainerListener> field_75149_d = new ArrayList<IContainerListener>();
    protected final NonNullList<ItemStack> field_75153_a = NonNullList.func_191196_a();

    public ContainerBase(int windowId, ContainerType<?> type, PlayerEntity player, IItemHandler inventory) {
        super(type, windowId);
        this.player = player;
        this.inventory = inventory;
        this.isClient = player.func_130014_f_().field_72995_K;
        this.playerInventory = player.field_71071_by;
        this.playerInv = new PlayerInvWrapperNoSync(player.field_71071_by);
        this.mergeSlotRangesExtToPlayer = new ArrayList<MergeSlotRange>();
        this.mergeSlotRangesPlayerToExt = new ArrayList<MergeSlotRange>();
        this.customInventorySlots = new MergeSlotRange(0, 0);
        this.playerMainSlotsIncHotbar = new MergeSlotRange(0, 0);
        this.playerMainSlots = new MergeSlotRange(0, 0);
        this.playerHotbarSlots = new MergeSlotRange(0, 0);
        this.playerOffhandSlots = new MergeSlotRange(0, 0);
        this.playerArmorSlots = new MergeSlotRange(0, 0);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    protected void reAddSlots(int playerInventoryX, int playerInventoryY) {
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        this.addCustomInventorySlots();
        this.addPlayerInventorySlots(playerInventoryX, playerInventoryY);
    }

    protected void addCustomInventorySlots() {
    }

    protected void addPlayerInventorySlots(int posX, int posY) {
        int playerInvStart = this.field_75151_b.size();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a((Slot)new SlotItemHandlerGeneric((IItemHandler)this.playerInv, i * 9 + j + 9, posX + j * 18, posY + i * 18));
            }
        }
        this.playerMainSlots = new MergeSlotRange(playerInvStart, 27);
        int playerHotbarStart = this.field_75151_b.size();
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a((Slot)new SlotItemHandlerGeneric((IItemHandler)this.playerInv, i, posX + i * 18, posY + 58));
        }
        this.playerMainSlotsIncHotbar = new MergeSlotRange(playerInvStart, 36);
        this.playerHotbarSlots = new MergeSlotRange(playerHotbarStart, 9);
    }

    protected void addOffhandSlot(int posX, int posY) {
        this.playerOffhandSlots = new MergeSlotRange(this.field_75151_b.size(), 1);
        this.func_75146_a((Slot)new SlotItemHandlerGeneric((IItemHandler)this.playerInv, 40, posX, posY){

            public String func_178171_c() {
                return "minecraft:items/empty_armor_slot_shield";
            }
        });
    }

    public PlayerEntity getPlayer() {
        return this.player;
    }

    public SlotRange getPlayerMainInventorySlotRange() {
        return this.playerMainSlotsIncHotbar;
    }

    public SlotRange getPlayerArmorSlots() {
        return this.playerArmorSlots;
    }

    public SlotRange getCustomInventorySlotRange() {
        return this.customInventorySlots;
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot instanceof SlotItemHandler && !this.playerInventory.func_70445_o().func_190926_b();
    }

    public Slot func_75139_a(int slotId) {
        return slotId >= 0 && slotId < this.field_75151_b.size() ? super.func_75139_a(slotId) : null;
    }

    public SlotItemHandlerGeneric getSlotItemHandler(int slotId) {
        Slot slot = this.func_75139_a(slotId);
        return slot instanceof SlotItemHandlerGeneric ? (SlotItemHandlerGeneric)slot : null;
    }

    public void func_75132_a(IContainerListener listener) {
        if (!this.field_75149_d.contains(listener)) {
            this.field_75149_d.add(listener);
            listener.func_71110_a((Container)this, this.func_75138_a());
            this.func_75142_b();
        }
    }

    public void func_82847_b(IContainerListener listener) {
        this.field_75149_d.remove(listener);
    }

    protected Slot func_75146_a(Slot slotIn) {
        slotIn.field_75222_d = this.field_75151_b.size();
        this.field_75151_b.add(slotIn);
        this.field_75153_a.add((Object)ItemStack.field_190927_a);
        return slotIn;
    }

    protected void syncCursorStackToClient() {
        this.syncStackToClient(-1, this.player.field_71071_by.func_70445_o());
    }

    protected void syncSlotToClient(int slotNum) {
        if (slotNum >= 0 && slotNum < this.field_75151_b.size()) {
            this.syncStackToClient(slotNum, this.func_75139_a(slotNum).func_75211_c());
        }
    }

    protected void syncStackToClient(int slotNum, ItemStack stack) {
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            IContainerListener listener = this.field_75149_d.get(i);
            if (!(listener instanceof ServerPlayerEntity)) continue;
            ServerPlayerEntity player = (ServerPlayerEntity)listener;
            PacketHandler.INSTANCE.sendTo((Object)new MessageSyncSlot(this.field_75152_c, slotNum, stack), player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public void syncStackInSlot(int slotId, ItemStack stack) {
        if (slotId == -1) {
            this.player.field_71071_by.func_70437_b(stack);
        } else {
            Slot slot = this.func_75139_a(slotId);
            if (slot instanceof SlotItemHandlerGeneric) {
                ((SlotItemHandlerGeneric)slot).syncStack(stack);
            } else {
                this.func_75141_a(slotId, stack);
            }
        }
    }

    public void func_75142_b() {
        if (!this.isClient) {
            for (int slot = 0; slot < this.field_75151_b.size(); ++slot) {
                ItemStack currentStack = ((Slot)this.field_75151_b.get(slot)).func_75211_c();
                ItemStack prevStack = (ItemStack)this.field_75153_a.get(slot);
                if (ItemStack.func_77989_b((ItemStack)prevStack, (ItemStack)currentStack)) continue;
                prevStack = currentStack.func_190926_b() ? ItemStack.field_190927_a : currentStack.func_77946_l();
                this.field_75153_a.set(slot, (Object)prevStack);
                this.syncStackToClient(slot, prevStack);
            }
        }
    }

    public ItemStack func_82846_b(PlayerEntity player, int slotNum) {
        this.transferStackFromSlot(player, slotNum);
        return ItemStack.field_190927_a;
    }

    protected boolean transferStackFromSlot(PlayerEntity player, int slotNum) {
        Slot slot = this.func_75139_a(slotNum);
        if (slot == null || !slot.func_75216_d() || !slot.func_82869_a(player)) {
            return false;
        }
        if (this.playerArmorSlots.contains(slotNum) || this.playerOffhandSlots.contains(slotNum)) {
            return this.transferStackToSlotRange(player, slotNum, this.playerMainSlotsIncHotbar, false);
        }
        if (this.playerMainSlotsIncHotbar.contains(slotNum)) {
            return this.transferStackFromPlayerMainInventory(player, slotNum);
        }
        return this.transferStackToSlotRange(player, slotNum, this.playerMainSlotsIncHotbar, true);
    }

    protected boolean transferStackFromPlayerMainInventory(PlayerEntity player, int slotNum) {
        if (this.transferStackToSlotRange(player, slotNum, this.playerArmorSlots, false)) {
            return true;
        }
        if (this.transferStackToPrioritySlots(player, slotNum, false)) {
            return true;
        }
        return this.transferStackToSlotRange(player, slotNum, this.customInventorySlots, false);
    }

    protected boolean transferStackToPrioritySlots(PlayerEntity player, int slotNum, boolean reverse) {
        boolean ret = false;
        for (MergeSlotRange slotRange : this.mergeSlotRangesPlayerToExt) {
            ret |= this.transferStackToSlotRange(player, slotNum, slotRange, reverse);
        }
        return ret;
    }

    protected boolean transferStackToSlotRange(PlayerEntity player, int slotNum, MergeSlotRange slotRange, boolean reverse) {
        SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
        if (slot == null || !slot.func_75216_d() || !slot.func_82869_a(player)) {
            return false;
        }
        ItemStack stack = slot.func_75211_c().func_77946_l();
        int amount = Math.min(stack.func_190916_E(), stack.func_77976_d());
        stack.func_190920_e(amount);
        stack = this.mergeItemStack(stack, slotRange, reverse, true);
        if (!stack.func_190926_b()) {
            if (!slot.func_75214_a(stack) || stack.func_190916_E() == amount) {
                return false;
            }
            amount -= stack.func_190916_E();
        }
        stack = slot.func_75209_a(amount);
        slot.func_190901_a(player, stack);
        stack = this.mergeItemStack(stack, slotRange, reverse, false);
        if (!stack.func_190926_b()) {
            slot.insertItem(stack, false);
            LowTechCrafting.logger.warn("Failed to merge all items in '{}'. This shouldn't happen and should be reported.", (Object)((Object)((Object)this)).getClass().getSimpleName());
        }
        return true;
    }

    protected int getMaxStackSizeFromSlotAndStack(Slot slot, ItemStack stack) {
        return !stack.func_190926_b() ? Math.min(slot.func_178170_b(stack), stack.func_77976_d()) : slot.func_75219_a();
    }

    protected boolean func_75135_a(ItemStack stack, int slotStart, int slotEndExclusive, boolean reverse) {
        return false;
    }

    protected ItemStack mergeItemStack(ItemStack stack, MergeSlotRange slotRange, boolean reverse, boolean simulate) {
        SlotItemHandlerGeneric slot;
        int slotIndex;
        int slotStart = slotRange.first;
        int slotEndExclusive = slotRange.lastExc;
        int n = slotIndex = reverse ? slotEndExclusive - 1 : slotStart;
        while (!stack.func_190926_b() && slotIndex >= slotStart && slotIndex < slotEndExclusive) {
            slot = this.getSlotItemHandler(slotIndex);
            if (slot != null && slot.func_75216_d() && slot.func_75214_a(stack)) {
                stack = slot.insertItem(stack, simulate);
            }
            slotIndex = reverse ? slotIndex - 1 : slotIndex + 1;
        }
        if (!stack.func_190926_b() && !slotRange.existingOnly) {
            int n2 = slotIndex = reverse ? slotEndExclusive - 1 : slotStart;
            while (!stack.func_190926_b() && slotIndex >= slotStart && slotIndex < slotEndExclusive) {
                slot = this.getSlotItemHandler(slotIndex);
                if (slot != null && !slot.func_75216_d() && slot.func_75214_a(stack)) {
                    stack = slot.insertItem(stack, simulate);
                }
                slotIndex = reverse ? slotIndex - 1 : slotIndex + 1;
            }
        }
        return stack;
    }

    protected void addMergeSlotRangeExtToPlayer(int start, int numSlots) {
        this.addMergeSlotRangeExtToPlayer(start, numSlots, false);
    }

    protected void addMergeSlotRangeExtToPlayer(int start, int numSlots, boolean existingOnly) {
        this.mergeSlotRangesExtToPlayer.add(new MergeSlotRange(start, numSlots, existingOnly));
    }

    protected void addMergeSlotRangePlayerToExt(int start, int numSlots) {
        this.addMergeSlotRangePlayerToExt(start, numSlots, false);
    }

    protected void addMergeSlotRangePlayerToExt(int start, int numSlots, boolean existingOnly) {
        this.mergeSlotRangesPlayerToExt.add(new MergeSlotRange(start, numSlots, existingOnly));
    }

    public void performGuiAction(PlayerEntity player, int action, int element) {
    }
}

