/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.lowtechcrafting.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;

public class NBTUtils {
    @Nonnull
    public static ItemStack setRootCompoundTag(@Nonnull ItemStack stack, @Nullable CompoundNBT nbt) {
        if (nbt != null && nbt.isEmpty()) {
            nbt = null;
        }
        stack.func_77982_d(nbt);
        return stack;
    }

    @Nullable
    public static CompoundNBT getRootCompoundTag(@Nonnull ItemStack stack, boolean create) {
        CompoundNBT nbt = stack.func_77978_p();
        if (!create) {
            return nbt;
        }
        if (nbt == null) {
            nbt = new CompoundNBT();
            stack.func_77982_d(nbt);
        }
        return nbt;
    }

    @Nullable
    public static CompoundNBT getCompoundTag(@Nullable CompoundNBT nbt, @Nonnull String tagName, boolean create) {
        if (nbt == null) {
            return null;
        }
        if (!create) {
            return nbt.func_150297_b(tagName, 10) ? nbt.func_74775_l(tagName) : null;
        }
        if (!nbt.func_150297_b(tagName, 10)) {
            nbt.func_218657_a(tagName, (INBT)new CompoundNBT());
        }
        return nbt.func_74775_l(tagName);
    }

    @Nullable
    public static CompoundNBT getCompoundTag(@Nonnull ItemStack stack, @Nullable String tagName, boolean create) {
        CompoundNBT nbt = NBTUtils.getRootCompoundTag(stack, create);
        if (tagName != null) {
            nbt = NBTUtils.getCompoundTag(nbt, tagName, create);
        }
        return nbt;
    }

    public static byte getByte(@Nonnull ItemStack stack, @Nullable String containerTagName, @Nonnull String tagName) {
        CompoundNBT nbt = NBTUtils.getCompoundTag(stack, containerTagName, false);
        return nbt != null ? nbt.func_74771_c(tagName) : (byte)0;
    }

    public static void setByte(@Nonnull ItemStack stack, @Nullable String containerTagName, @Nonnull String tagName, byte value) {
        CompoundNBT nbt = NBTUtils.getCompoundTag(stack, containerTagName, true);
        nbt.func_74774_a(tagName, value);
    }

    public static void cycleByteValue(@Nonnull CompoundNBT nbt, @Nonnull String tagName, int minValue, int maxValue, boolean reverse) {
        byte value = nbt.func_74771_c(tagName);
        if (reverse) {
            if ((value = (byte)(value - 1)) < minValue) {
                value = (byte)maxValue;
            }
        } else if ((value = (byte)(value + 1)) > maxValue) {
            value = (byte)minValue;
        }
        nbt.func_74774_a(tagName, value);
    }

    public static void cycleByteValue(@Nonnull ItemStack stack, @Nullable String containerTagName, @Nonnull String tagName, int maxValue, boolean reverse) {
        CompoundNBT nbt = NBTUtils.getCompoundTag(stack, containerTagName, true);
        NBTUtils.cycleByteValue(nbt, tagName, 0, maxValue, reverse);
    }

    public static void readByteArrayIntoIntArray(int[] arr, CompoundNBT nbt, String tagName) {
        byte[] arrBytes = nbt.func_74770_j(tagName);
        int len = Math.min(arr.length, arrBytes.length);
        for (int i = 0; i < len; ++i) {
            arr[i] = arrBytes[i];
        }
    }

    public static void writeIntArrayAsByteArray(int[] arr, CompoundNBT nbt, String tagName) {
        byte[] bytes = new byte[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            bytes[i] = (byte)arr[i];
        }
        nbt.func_74773_a(tagName, bytes);
    }

    public static void readByteArray(byte[] arr, CompoundNBT nbt, String tagName) {
        byte[] arrNbt = nbt.func_74770_j(tagName);
        int len = Math.min(arr.length, arrNbt.length);
        for (int i = 0; i < len; ++i) {
            arr[i] = arrNbt[i];
        }
    }

    public static void readIntArray(int[] arr, CompoundNBT nbt, String tagName) {
        int[] arrNbt = nbt.func_74759_k(tagName);
        int len = Math.min(arr.length, arrNbt.length);
        for (int i = 0; i < len; ++i) {
            arr[i] = arrNbt[i];
        }
    }

    @Nonnull
    public static ItemStack loadItemStackFromTag(@Nonnull CompoundNBT tag) {
        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)tag);
        if (tag.func_150297_b("ActualCount", 3)) {
            stack.func_190920_e(tag.func_74762_e("ActualCount"));
        }
        return stack.func_190926_b() ? ItemStack.field_190927_a : stack;
    }

    @Nonnull
    public static CompoundNBT storeItemStackInTag(@Nonnull ItemStack stack, @Nonnull CompoundNBT tag) {
        if (!stack.func_190926_b()) {
            stack.func_77955_b(tag);
            if (stack.func_190916_E() > 127) {
                tag.func_74774_a("Count", (byte)(stack.func_190916_E() & 0x7F));
                tag.func_74768_a("ActualCount", stack.func_190916_E());
            }
        }
        return tag;
    }

    public static void readStoredItemsFromTag(@Nonnull CompoundNBT nbt, NonNullList<ItemStack> items, @Nonnull String tagName) {
        if (!nbt.func_150297_b(tagName, 9)) {
            return;
        }
        ListNBT nbtTagList = nbt.func_150295_c(tagName, 10);
        int num = nbtTagList.size();
        int listSize = items.size();
        for (int i = 0; i < num; ++i) {
            CompoundNBT tag = nbtTagList.func_150305_b(i);
            short slotNum = tag.func_74765_d("Slot");
            if (slotNum < 0 || slotNum >= listSize) continue;
            items.set((int)slotNum, (Object)NBTUtils.loadItemStackFromTag(tag));
        }
    }

    @Nonnull
    public static NonNullList<ItemStack> readStoredItemsFromTag(@Nonnull CompoundNBT nbt, @Nonnull String tagName) {
        NonNullList items = NonNullList.func_191196_a();
        if (!nbt.func_150297_b(tagName, 9)) {
            return items;
        }
        ListNBT nbtTagList = nbt.func_150295_c(tagName, 10);
        int size = nbtTagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundNBT tag = nbtTagList.func_150305_b(i);
            items.add((Object)NBTUtils.loadItemStackFromTag(tag));
        }
        return items;
    }

    @Nonnull
    public static ListNBT createTagListForItems(NonNullList<ItemStack> items) {
        ListNBT nbtTagList = new ListNBT();
        int invSlots = items.size();
        for (int slotNum = 0; slotNum < invSlots; ++slotNum) {
            ItemStack stack = (ItemStack)items.get(slotNum);
            if (stack.func_190926_b()) continue;
            CompoundNBT tag = NBTUtils.storeItemStackInTag(stack, new CompoundNBT());
            if (invSlots <= 127) {
                tag.func_74774_a("Slot", (byte)slotNum);
            } else {
                tag.func_74777_a("Slot", (short)slotNum);
            }
            nbtTagList.add((Object)tag);
        }
        return nbtTagList;
    }

    @Nonnull
    public static CompoundNBT writeItemsToTag(@Nonnull CompoundNBT nbt, NonNullList<ItemStack> items, @Nonnull String tagName, boolean keepExtraSlots) {
        int invSlots = items.size();
        ListNBT nbtTagList = NBTUtils.createTagListForItems(items);
        if (keepExtraSlots && nbt.func_150297_b(tagName, 9)) {
            ListNBT nbtTagListExisting = nbt.func_150295_c(tagName, 10);
            int count = nbtTagListExisting.size();
            for (int i = 0; i < count; ++i) {
                CompoundNBT tag = nbtTagListExisting.func_150305_b(i);
                short slotNum = tag.func_74765_d("Slot");
                if (slotNum < invSlots) continue;
                nbtTagList.add((Object)tag);
            }
        }
        if (nbtTagList.size() > 0) {
            nbt.func_218657_a(tagName, (INBT)nbtTagList);
        } else {
            nbt.func_82580_o(tagName);
        }
        return nbt;
    }
}

